package LCM::Configuration::ValueChangeListeners::DownloadComponents::DownloadOnHANAListener;

use strict;
use SDB::Install::Configuration qw($bool_true_pattern);

my $EXTRACTION_PARAMETER_IDS = [
    'DownloadDir',
    'ExtractTempDir',
    'SapcarLocation',
    'OverwriteExtractDir',
    'ExtractAfterDownload',
    'TarExecutableLocation',
    'ComponentArchivesPath',
    'UnrarExecutableLocation',
];

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $shallSkip = ($value =~ /$bool_true_pattern/) ? 0 : 1;

    for my $parameterId (@{$EXTRACTION_PARAMETER_IDS}){
        $configuration->setSkip($parameterId, $shallSkip);
    }
    return 1;
}

1;