package LCM::Configuration::ValueChangeListeners::ExtractComponents::ComponentArchivesDirListener;

use strict;
use LCM::FileUtils qw(listDirectory);
use File::Spec qw(catfile);

sub new {
    my $class = shift();
    return bless({}, $class);
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $defaultExtractDir = File::Spec->catfile($value, 'extracted');

    $configuration->setDefault("ExtractTempDir", $defaultExtractDir, 1);
    $configuration->setSkip("TarExecutableLocation", $self->_shouldSkipTarExecutable($value));
    $configuration->setSkip("UnrarExecutableLocation", $self->_shouldSkipUnrarExecutable($value));
    return 1;
}

sub _shouldSkipUnrarExecutable {
    my ($self, $path) = @_;
    my $contents = LCM::FileUtils::listDirectory($path) || [];
    my $hasRarArchives = grep(/\.(rar|EXE)$/i, @$contents);

    return $hasRarArchives ? 0 : 1;
}

sub _shouldSkipTarExecutable {
    my ($self, $path) = @_;
    my $contents = LCM::FileUtils::listDirectory($path) || [];
    my $hasTarArchives = grep(/\.(tar|tgz|tbz|tlz)/i, @$contents);

    return $hasTarArchives ? 0 : 1;
}

1;