package LCM::Configuration::ValueChangeListeners::Install::InstallHostagentListener;

sub new {
	my ($class) = @_;

	my $self = {
		"off"	=> 0,
		"on"	=> 1
	};
	bless $self, $class;

	return $self;
}

sub onValueChange {
	my ($self, $value, $instconfig) = @_;
	
	if ( $instconfig->isUseSAPHostagent() ) {
		return 1;
	}

	if ( $value eq $self->{'off'} ) {
		$instconfig->setSkip( "CertificatesHostmap", 1 );
		$instconfig->setSkip( "InitialHostagentPassword", 1 );
		$instconfig->setValue('DeploySHAConfigurations', 0);
	}

	return 1;
}

1;