package LCM::Configuration::ValueChangeListeners::InstallUpdate::InstallXSInDefaultTenantListener;

use strict;

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $tenantName = $value ? $configuration->getSID() : undef;

    $configuration->setSkip('XSTenantDatabaseName', !$value);
    $configuration->setInteractive('XSTenantDatabaseName', !$value);
    $configuration->setHidden('XSTenantDatabaseName', $value);
    $configuration->setDefault('XSTenantDatabaseName', $tenantName, 1);

    return 1;
}

1;