package LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationBatchListener;

use strict;
use warnings;
use SDB::Install::Globals qw($gFailedSignatureVerificationMessage);
use parent 'LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationListenerBase';


sub handleSapdsignerLogging {
    my ($self, $sapdsigner, $instconfig) = @_;
    if ($instconfig->getIgnore('verify_signature')) {
        my $configMsgLst = $instconfig->getMsgLst();
        $sapdsigner->setMsgLstContext([ $configMsgLst, $configMsgLst ]);
    } else {
        $self->SUPER::handleSapdsignerLogging($sapdsigner, $instconfig);
    }
}

# Override
sub onErrorMessage {
    my ($self, $msg, $configuration) = @_;
    $configuration->getErrMsgLst()->addError($msg);
}

sub handleVerificationFailure {
    my ($self, $instconfig) = @_;
    $instconfig->getErrMsgLst()->addError($gFailedSignatureVerificationMessage);
    $instconfig->getErrMsgLst()->addError("To ignore component authentication failures, use the --ignore=verify_signature switch.");
    return 0;
}

1;
