package LCM::Configuration::ValueChangeListeners::LSSParameterListener;

use strict;
use warnings;



sub new { return bless({}, shift()); }

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $skip = $self->shouldSkipLssParams($value, $configuration);
    $self->skipLssUserParams($configuration,$skip);
    return 1;
}

sub shouldSkipLssParams {
    my($self, $value, $configuration) = @_;
    my $lss = $configuration->getOwnInstance()->getLssInstance();
    return defined $lss ? 0 : 1;
}

sub skipLssUserParams {
    my ($self,$configuration,$skip) = @_;
    $configuration->skipLSSUserParams($skip);
}

1;
