package LCM::Configuration::ValueChangeListeners::RemoveHostRoles::SIDListener;
use strict;

sub new {
    my ($class) = @_;
    my $self = {};
    bless $self, $class;
    return $self;
}

sub onValueChange{
    my ($self, $value, $configuration) = @_;
    my $systemHosts = $configuration->getSystemHosts();
    $configuration->{params}->{RemoveRoles}->{origin_values} = $systemHosts;
    $configuration->{params}->{RemoveRoles}->{default_map} = { map { ($_ => '') } @{$systemHosts} };
    return 1;
}

1;
