package LCM::Configuration::ValueChangeListeners::Rename::RemoteExecutionListener;
use strict;

sub new{
     my ( $class ) = @_;

     my $self = {};
     bless $self, $class;

     return $self;
}

sub onValueChange{
    my ( $self, $value, $instconfig ) = @_;

    return 1 if $value ne 'saphostagent';
    if (!$instconfig->isDistributedSystem()) {
        $instconfig->enableHostagentPasswordIfRequired();
    } else {
        $instconfig->{params}->{HostagentPassword}->{type} = 'passwd';
        $instconfig->setSkip('HostagentPassword', 0);
    }

    return 1;
}

1;
