package LCM::Configuration::ValueChangeListeners::Rename::ReplicationCleanupListener;

use strict;
use LCM::Utils::CommonUtils;

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    my $flavourProductName = $instconfig->getFlavourProductName();
    my $isSystemReplication = LCM::Utils::CommonUtils::isSystemReplication($instconfig);
    return 1 if $instconfig->isRegisterScenario();
    return 0 if (!defined $isSystemReplication);

    if ($isSystemReplication && !$value) {
        $instconfig->resetError();
        $instconfig->setErrorMessage("The $flavourProductName System cannot be renamed, because system replication is enabled");
        return 0;
    }

    return 1;
}

1;
