package LCM::Configuration::ValueChangeListeners::Update::DeprecatedComponentsListener;
use strict;
use warnings;

use LCM::Component::Installable::HDBServer::HDBServerBase;
use SDB::Install::Globals qw($gKeynameEngine $gKeynameRDSync $gProductNameEngine);

sub new {
    return bless({}, $_[0]);
}

sub onValueChange {
    my ($self, $selectedCmpsValue, $configuration) = @_;

    return undef if(!$configuration->fillSelectedComponents($selectedCmpsValue));

    my $deprecatedComponentKeynames = LCM::Component::Installable::HDBServer::HDBServerBase::getDeprecatedComponentKeynames();
    return 1 if (!@$deprecatedComponentKeynames);

    my $mediumComponentManager = $configuration->getMediumComponentManager();
    my $isUpdatingServer = $mediumComponentManager->isComponentSelected($gKeynameEngine);
    return 1 if (!$isUpdatingServer);

    my $hasDeprecatedComponents = 0;
    my $systemComponentManager = $configuration->getSystemComponentManager();
    for my $installedComponent (@{$systemComponentManager->getAllComponents()}) {
        my $keyname = $installedComponent->getComponentKeyName();
        if (grep {$_ eq $keyname} @$deprecatedComponentKeynames) {
            $self->_addDeprecatedComponentWarning($installedComponent, $configuration);
            $hasDeprecatedComponents = 1;
            $configuration->setNoRetry('SelectedComponents', 1);
        }
    }
    return ($hasDeprecatedComponents) ? 0 : 1;
}

sub _addDeprecatedComponentWarning {
    my ($self, $component, $configuration) = @_;
    my $componentName = $component->getComponentName();
    my $error = "An already installed component, $componentName, is no longer available and needs to be uninstalled before updating the $gProductNameEngine.";

    my $deprecatedInfo = $component->getDeprecatedInfo();
    if (defined $deprecatedInfo) {
        $error .= " $deprecatedInfo";
    }
    $configuration->getErrMsgLst()->addError($error);
}

1;