package LCM::Configuration::ValueChangeListeners::Update::MetadataSeparationCheckListener;
use strict;

use SDB::Install::Globals qw ($gKeynameEngine);
use SDB::Install::Configuration::ServerUpgradeChecker;

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $selectedCmpsValue, $instconfig) = @_;

    my $mcm = $instconfig->getMediumComponentManager ();
    my $serverComponent = $mcm->getComponentByKeyName ($gKeynameEngine);

    if (!defined $serverComponent){
        return 1;
    }

    my $serverKey = $serverComponent->getComponentBatchKey ();
    if (!(grep {/^all$|^$serverKey$/} split (',', $selectedCmpsValue))){
        return 1;
    }

    my $upgradeChecker = new SDB::Install::Configuration::ServerUpgradeChecker ();
    $upgradeChecker->setMsgLstContext($instconfig->getMsgLstContext());
    if (!$upgradeChecker->checkMetaDataSeparation ($instconfig->getSAPSystem())){
        $instconfig->setNoRetry('SelectedComponents', 1);
        return undef;
    }
    return 1;
}

1;
