package LCM::Configuration::ValueChangeListeners::Update::RootUserListener;
use parent qw (LCM::Configuration::ValueChangeListeners::PostCollectHostInfoChecksListener);

use strict;
use SDB::Install::Configuration qw($bool_true_pattern);

sub new { return bless ({}, shift()); }

sub onValueChange {
    my ($self, $rootUser, $config) = @_;
    my $remoteHosts;
    my $failed = 0;
    foreach $remoteHosts (@{$config->getRemoteHostsObjects()}){
        $remoteHosts->connect();
        $remoteHosts->setUserName( $rootUser );
        my $returnCode = $remoteHosts->authKey(1);
        if ( $returnCode ) {
            $failed = 1;
        }
    }
    $config->setSkip ('RootPassword', !$failed);
    if ($failed){
        $self->_authenticateRemoteConnectionWithPassword($config);
        return 1;
    }

    if (! $self->checkCollectedHostInfo($config)) {
        $config->setNoRetry('RootUser', 1);
        return 0;
    }
    
    require LCM::Configuration::ValueChangeListeners::FillingCertificatesListener;
    my $fillingCertificatesHelper = new LCM::Configuration::ValueChangeListeners::FillingCertificatesListener();
    $fillingCertificatesHelper->onValueChange( undef, $config );
    
    require LCM::Configuration::ValueChangeListeners::CertificatesSkipValueConfigurator;
    my $skippingCertificatesHelper = new LCM::Configuration::ValueChangeListeners::CertificatesSkipValueConfigurator();
    $skippingCertificatesHelper->configureSkippingCertificates($config);

    my $shallInstallSHA = ($config->getValue('InstallHostagent') =~ /$bool_true_pattern/);
    if($shallInstallSHA){
        $config->setSkip('HostagentPassword', $config->_shouldSkipHostagentPassword());
    }
    $config->setupInterServiceCommunicationParameters();
    if (!$config->initLSSGroupAndUserID()){
        return 0;
    }

    return 1;
}

sub _authenticateRemoteConnectionWithPassword {
    my ($self, $config) = @_;
    require LCM::Configuration::ValueChangeListeners::Update::RootPasswordListener;
    $config->addParameterListener( 'RootPassword', LCM::Configuration::ValueChangeListeners::Update::RootPasswordListener->new() );
}

1;
