package LCM::Configuration::ValueChangeListeners::Update::SystemDBSQLPasswordBatchHandler;

use strict;
use warnings;

sub new {
	my ($class) = @_;
	my $self = {};
	bless $self, $class;
	return $self;
}

sub onValueChange {
	my ($self, $value, $config) = @_;
	my $appContext = LCM::App::ApplicationContext::getInstance();
    return 1 if !$appContext->isBatch();
    return 1 if !($config->isConvertToMultiDbResumed() || $config->isConvertToMultiDbRequired());
    return 1 if $self->hasSystemDBSQLPasswordBatchValue($config);
    return 1 if ($config->getOwnInstance()->isSecondarySystem() && ($config->getValue('SystemUser') ne 'SYSTEM'));

    $config->getMsgLst()->addMessage($config->getParamName('SystemDBSQLPassword').' is not set : value of '.$config->getParamName('SQLSysPasswd'). ' will be used instead');
    $config->setSystemDBSQLPasswordSetByUser(0);
    return $config->setValue('SystemDBSQLPassword', $value);
}

sub hasSystemDBSQLPasswordBatchValue{
    my($self,$config) = @_;
    if (defined $config->{options}->{read_password_from_stdin}){
        return 1 if( defined $config->getPasswordFromXML(undef,$config->{params}->{'SystemDBSQLPassword'},1) );
    } else {
        return 1 if ( defined $config->getBatchValue('SystemDBSQLPassword'));
    } 
    return 0 ;
}

1;