package LCM::Configuration::ValueChangeListeners::Update::XS::BaseUpdateXSDetectionListener;

use strict;

use LCM::Component;
use File::Spec;
use File::Basename;
use SDB::Install::Globals qw ($gKeynameXS2);

sub getConfigParameter{
    ...
}

sub getAdminLoginParameter{
    ...
}

sub onValueChange {
    my ($self, undef, $instconfig) = @_;

    if($self->_requireDefaultValueUpdate($instconfig)){
        $self->_updateDefaultValueFromAdminLogin($instconfig);
    }
    return 1;
}

sub _updateDefaultValueFromAdminLogin{
    my ($self, $instconfig) = @_;
    my $adminLoginValue = $instconfig->retrieveXsAdminLoginParam($self->getAdminLoginParameter());
    if ($adminLoginValue) {
        # If we've fetched the parameter from the xs-admin-login successfully, set it as default value
        $instconfig->setDefault($self->getConfigParameter(), $adminLoginValue);
    }
}

sub _requireDefaultValueUpdate{
    my ($self, $instconfig) = @_;
    my $isUpdatingXs = $instconfig->isUpdatingComponent($gKeynameXS2);
    my $hasValue = $instconfig->hasValue($self->getConfigParameter());
    my $batchValue = $instconfig->getBatchValue($self->getConfigParameter());
    my $hasBatchValue = defined($batchValue) && length($batchValue) > 0;
    return 1 if($isUpdatingXs && !$hasValue && !$hasBatchValue);
}

1;
