package LCM::Configuration::ValueChangeListeners::XsSpaceIsolationListener;

use strict;
use SDB::Install::User;
use LCM::App::ApplicationContext;
use SDB::Common::Utils qw(createXSSpaceSAPUserName createXSSpaceProdUserName);
use SDB::Install::Configuration qw($bool_true_pattern);

my $PARAMETER_ID_SPACE_ISOLATION = 'XSSpaceIsolation';
my $PARAMETER_ID_SAP = 'XSSpaceUserIdSAP';
my $PARAMETER_ID_PROD = 'XSSpaceUserIdProd';

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $userNameSAP = createXSSpaceSAPUserName($configuration->getSID());
    my $userNameProd = createXSSpaceProdUserName($configuration->getSID());
    $self->{tempReservedIDs} = $configuration->getReservedUserIDs();
    if(!$self->_handleOsUserId($configuration, $userNameSAP, $PARAMETER_ID_SAP)){
        $configuration->setNoRetry($PARAMETER_ID_SPACE_ISOLATION, 1);
        return undef;
    }
    if(!$self->_handleOsUserId($configuration, $userNameProd, $PARAMETER_ID_PROD)){
        return undef;
    }
    return 1;
}

sub _handleOsUserId {
    my ($self, $configuration, $userName, $parameterId) = @_;
    my $applicationContext = LCM::App::ApplicationContext::getInstance();

    if($configuration->isSkipped($parameterId)){
        return 1;
    }
    my $existingId = $configuration->getExistingUserId($userName);
    if(defined($existingId)){
        return $configuration->handleExistingOsID($existingId, $parameterId);
    }
    if($applicationContext->getMode() =~ /^CLI|Batch$/){
        $self->_updateUIStringByTemplate($configuration, $userName, $parameterId);
    }
    $self->_handleDefaultUserId($configuration, $parameterId);
    return 1;
}

sub _handleDefaultUserId {
    my ($self, $configuration, $parameterId) = @_;
    my $freeUID = $configuration->getFreeOsUserID(undef, $self->{tempReservedIDs});
    $configuration->setDefault($parameterId, $freeUID);
    $configuration->setHidden($parameterId, 0);
    push @{$self->{tempReservedIDs}}, $freeUID;
}

sub _updateUIStringByTemplate {
    my ($self, $configuration, $userName, $parameterId) = @_;
    my $parameter = $configuration->{params}->{$parameterId};

    if(defined($parameter) && defined($parameter->{str_templ})){
        $parameter->{str} = sprintf($parameter->{str_templ}, $userName);
    }
}

1;
