package LCM::Configuration::Web::RemoveHostRolesConfiguration;

use strict;
use parent qw(LCM::Configuration::RemoveHostRolesConfiguration);
use LCM::App::RemoveHostRolesUtils qw(getRemovableRolesForExistingHosts);
use LCM::Configuration::ParametersCreator qw(GetParamExistingHosts GetParamIgnore);

sub new {
    my $self = shift()->SUPER::new(@_);

    for my $parameterId ('Target', 'SID', 'RemoteExecution', 'InstallSSHKey', 'UseHttp'){
        $self->setHidden($parameterId, 1);
    }
    $self->setValue('RemoteExecution', 'saphostagent');
    $self->_addSlpSpecificParameters();

    return $self;
}

sub _addListeners {
    my $self = shift();
    $self->SUPER::_addListeners(@_);
    $self->addParameterListener('SID', sub {
        $self->_initParamExistingHosts();
        $self->_initParamRemovableHostRoles();
    });
}

sub checkRemoveRoles {
    my ($self, $host, $roles) = @_;
    return 1 if($roles eq '');
    return $self->SUPER::checkRemoveRoles($host, $roles);
}

sub setRemoveRoles {
    my ($self, $host, $roles) = @_;
    return $self->SUPER::setRemoveRoles($host, $roles) if($roles ne '');
    delete($self->{params}->{RemoveRoles}->{value}->{$host});
    return 1;
}

sub _initParamExistingHosts {
    my ($self) = @_;
    my $existingHostsParameter = $self->{params}->{ExistingHosts};
    my $instance = $self->getOwnInstance(1);
    my $hostRolesInfo = $instance->getHostRolesInfo();
    my @existingHostsWithRoles = map { "${_}:role=" . join(':role=', split('\s+', $hostRolesInfo->{$_})) } @{$self->getSystemHosts()};

    $existingHostsParameter->{value} = join(',', @existingHostsWithRoles);
}

sub _initParamRemovableHostRoles {
    my ($self) = @_;
    my $removableHostRolesParameter = $self->{params}->{RemovableHostRoles};
    my $existingHostToRemovableRolesMap = getRemovableRolesForExistingHosts($self);
    my $instance = $self->getOwnInstance(1);
    my $hostRolesInfo = $instance->getHostRolesInfo();
    my @result = ();

    for my $host (@{$self->getSystemHosts()}) {
        my @removableRoles = exists($existingHostToRemovableRolesMap->{$host}) ? @{$existingHostToRemovableRolesMap->{$host}} : ();
        my $validHostRolesString = "$host:role=" . join(':role=', @removableRoles);
        push(@result, $validHostRolesString);
    }

    $removableHostRolesParameter->{value} = join(',', @result);
}

sub _addSlpSpecificParameters {
    my ($self) = @_;
    my $order = scalar(keys(%{$self->{params}}));
    my $section = $self->{params}->{RemoveRoles}->{section};

    $self->{params}->{ExistingHosts} = GetParamExistingHosts($order++, $section);
    $self->{params}->{RemovableHostRoles} = $self->_getParamRemovableHostRoles($order++, $section);

    my $ignoreValues = $self->getIgnoreValues();
    if(defined($ignoreValues) && scalar(@{$ignoreValues})){
        $self->{params}->{Ignore} = GetParamIgnore($order++, $section, $ignoreValues);
    }
}

sub _getParamRemovableHostRoles {
    my ($self, $order, $section) = @_;
    return {
        'order'             => $order,
        'opt'               => 'removable_host_roles',
        'type'              => 'string',
        'section'           => $section,
        'value'             => undef,
        'init_with_default' => 0,
        'set_interactive'   => 0,
        'str'               => 'Removable Host Roles',
        'mandatory'         => 0,
    };
}

1;