package LCM::EnvironmentWrapper;

use strict;
use SDB::Install::SysVars qw ($isWin);
use SDB::Install::SAPSystem qw(CollectSAPSystems);
use SDB::Install::User;

my $getHdbInstance = sub {
	my ($sid) = @_;
	my $allSystems = CollectSAPSystems( undef, 1 );
	my $ownSystem = $allSystems->{$sid};

	if (defined($ownSystem) && $ownSystem->hasNewDB()){
		return $ownSystem->getNewDBInstances()->[0];
	}
	return undef;
};

# Usage - first cmd line option MUST be the SID, the other options represent the wanted command + arguments
sub main {
	my ($sid, @command) = @ARGV;
	my $hdbInstance = $getHdbInstance->($sid);

	_exitOnError(1, "Unable to get HDB Instance for SID '$sid'\n") if(!defined($hdbInstance));

	$ENV{SAPSYSTEMNAME} = $sid;
	$ENV{PATH} = join(':', $hdbInstance->get_instanceExeDir(), $ENV{PATH});
	$hdbInstance->_getHDBEnv(\%ENV);

	if(!$isWin && ($> == 0 || $) == 0)){
		my $sidadmUserName = sprintf('%sadm', lc($sid));
		my $sidadmUser = new SDB::Install::User ($sidadmUserName);
		if($sidadmUser->exists ()){
			$) = $( = $sidadmUser->gid (); # set both egid and rgid (set first gid, otherwise set of uid is not possible)
			$< = $> = $sidadmUser->id (); # set both euid and ruid
			if ($> == 0 || $) == 0 || $< == 0 || $( == 0) {
				my $err = "Could not switch to user '$sidadmUserName' to start external program '@command'\n";
				$err .= "Was only able to switch to the following gid and uid values: egid = $), rgid = $(, euid = $>, ruid = $<\n";
				_exitOnError(2, $err);
			}
		}
	}
	exec(@command) or _exitOnError(3, "Could not start external program '@command': $!\n");
}

sub _exitOnError {
	my ($exitCode, $message) = @_;
	print STDERR $message;
	exit $exitCode;
}

1;
