package LCM::FeatureManager::Feature;

use strict;
use warnings;
use parent 'SDB::Install::Base';
use SDB::Install::Version;

sub new {
    my $self = shift->SUPER::new();
    my ($id, $lowerBound, $upperBound, $referenceVersion) = @_;
    $self->_setLowerBound($lowerBound);
    $self->_setUpperBound($upperBound);
    $self->_setId($id);
    $self->_setReferenceVersion($referenceVersion);
    return $self;
}

sub _setId {
    my ($self, $id) = @_;
    $self->{_id} = $id;
}

sub _setLowerBound {
    my ($self, $lowerBound) = @_;
    $self->{_lowerBound} = $lowerBound;
}

sub _setUpperBound {
    my ($self, $upperBound) = @_;
    $self->{_upperBound} = $upperBound;
}

sub _setReferenceVersion {
    my ($self, $referenceVersion) = @_;
    $self->{_referenceVersion} = $referenceVersion;
}

sub getID {
    my ($self) = @_;
    return $self->{_id};
}

sub _getUpperBound {
    my ($self) = @_;
    return $self->{_upperBound};
}

sub _getLowerBound {
    my ($self) = @_;
    return $self->{_lowerBound};
}

sub _getReferenceVersion {
    my ($self) = @_;
    return $self->{_referenceVersion};
}

sub _isUpperBoundSatisfied {
    my ($self) = @_;
    my $upperBound = $self->_getUpperBound();
    return 1 if !$upperBound;
    my $srcVersion = $self->_getReferenceVersion();
    return 0 if !$srcVersion;

    my $upperBoundVersion = SDB::Install::Version->new(@{$upperBound});
    return $srcVersion->isOlderThan($upperBoundVersion) || $srcVersion->isEqual($upperBoundVersion);
}

sub _isLowerBoundSatisfied {
    my ($self) = @_;
    my $lowerBound = $self->_getLowerBound();
    return 1 if !$lowerBound;
    my $srcVersion = $self->_getReferenceVersion();
    return 0 if !$srcVersion;

    my $lowerBoundVersion = SDB::Install::Version->new(@{$lowerBound});
    return $srcVersion->isNewerThan($lowerBoundVersion) || $srcVersion->isEqual($lowerBoundVersion);
}

sub isEnabled {
    my ($self) = @_;
    my $isUpperBoundSatisfied = $self->_isUpperBoundSatisfied();
    my $isLowerBoundSatisfied = $self->_isLowerBoundSatisfied();
    return $isUpperBoundSatisfied && $isLowerBoundSatisfied;
}

1;