package LCM::FeatureManager::GenericFeatureManager;

use strict;
use warnings;
use parent qw(SDB::Install::Base Exporter);

use constant {
    OPTIMIZED_INSTALL   => 'optimized_installation',
    SECURE_STORE        => 'secure_store',
    UDS_COMMUNICATION   => 'uds_communication',
    VOLUME_ENCRYPTION   => 'volume_encryption',
    LSS_TRUST_UNSIGNED_SERVER   => 'lss_trust_unsigned_server',
};

our @EXPORT = qw(OPTIMIZED_INSTALL SECURE_STORE UDS_COMMUNICATION VOLUME_ENCRYPTION LSS_TRUST_UNSIGNED_SERVER);


sub new {
    my $self = shift->SUPER::new(@_);
    my ($config) = @_;
    $self->_setConfiguration($config);
    $self->{features} = {};
    return $self;
}

sub _setConfiguration {
    my ($self, $config) = @_;
    $self->{_configuration} = $config;
}

sub _getConfiguration {
    my ($self) = @_;
    return $self->{_configuration};
}

sub getFeaturesMap {
    my ($self) = @_;
    return $self->{features};
}

sub addFeature {
    my ($self, $feature) = @_;
    $self->{features}->{$feature->getID()} = $feature;
}

sub getFeatureByID {
    my ($self, $id) = @_;
    my $featureMap = $self->getFeaturesMap();
    return $featureMap->{$id};
}

sub isFeatureSupported {
    my ($self, $featureId) = @_;
    my $feature = $self->getFeatureByID($featureId);

# Assume that if a feature is not managed in the feature manager, it is supported
    return $feature ? $feature->isEnabled() : 1;
}

# ----- Convenience methods -------------------------------------------------

sub isOptimizedInstallationSupported {
    my ($self) = @_;
    return $self->isFeatureSupported(OPTIMIZED_INSTALL);
}

sub isSecureStoreSupported {
    my ($self) = @_;
    return $self->isFeatureSupported(SECURE_STORE);
}

sub isUDSCommunicationSupported {
    my ($self) = @_;
    return $self->isFeatureSupported(UDS_COMMUNICATION);
}

sub isVolumeEncryptionSupported {
    my ($self) = @_;
    return $self->isFeatureSupported(VOLUME_ENCRYPTION);
}

# This feature should be supported only when LSS component is selected and it consumes the updated LCMsdk version
sub isLssTrustUnsignedServerSupported {
    my ($self) = @_;
    my $feature = $self->getFeatureByID(LSS_TRUST_UNSIGNED_SERVER);
    return $feature ? $feature->isEnabled() : 0;
}

1;