package LCM::Gui::ComponentManager::SelectComponentSourceOutputHandler;

use strict;
use warnings;

use Wx qw (wxLIGHT_GREY wxOK wxICON_INFORMATION wxSYS_COLOUR_WINDOW);

our $SYSTEM_BACKGROUND = Wx::SystemSettings::GetColour ( wxSYS_COLOUR_WINDOW );
our $COLOR_LIGHT_BLUE = new Wx::Colour ( 229, 241, 255 );

sub new {
    my($class, $dialog) = @_;
    my $self =  bless({}, $class);
    $self->{dialog} = $dialog;
    $self->{_hasDefaultComponents} = $dialog->getComponentManager()->hasComponents();
    return $self;
}

sub printDetectedComponents {
    my($self, $cfg, $componentList, $noCache) = @_;

    if($noCache){
        $self->_clearComponentList();
        $self->{dialog}->resetComponentList();
    }

    if ( not scalar @$componentList ) {
        my $msgDialog =
            new Wx::MessageDialog ( $self->{dialog} , "No components were found in the specified location",
            "Info", wxOK | wxICON_INFORMATION );
        $msgDialog->ShowModal ();
        return;
    }

    my $error = $cfg->getErrorString();
    $self->{dialog}->setWarningText($error) if($error);

    my $components = $self->_getComponentList();
    my $checkForNewLocation = ($self->hasDefaultDetectedComponents() && scalar(@$components) == 0) ? 0 : 1;

    foreach my $component ( @$componentList ) {
        if ($cfg->isBootstrapFromResident() && $component->isServer() && $self->isNewLocation($component)) {
            next;
        }
        next if ( $component->isInternal () );
        $self->_addComponent ($cfg, $component, $checkForNewLocation);
    }
}

sub isNewLocation {
    my($self, $component) = @_;
    my $components = $self->_getComponentList();
    my @foundComponent = grep {$_->getComponentKeyName() eq $component->getComponentKeyName()} @$components;
    return 1 if(!@foundComponent);
    my $originalComponentPath = $foundComponent[0]->getPath();
    return $component->getPath() ne $originalComponentPath ? 1 : 0;
}

sub _addComponent {
    my ( $self, $cfg, $component, $checkForNewLocation ) = @_;

    my $components = $self->_getComponentList();
    my $id;
    my @componentIndex = grep { @$components[$_]->getComponentKeyName() eq $component->getComponentKeyName() } 0..$#$components;
    my $isNewItem = @componentIndex ? 0 : 1 ;
    my $newLocation = $checkForNewLocation && $self->isNewLocation($component);
    if ( !$isNewItem ) {
        splice( @$components, $componentIndex[0], 1, $component );
        $id = $componentIndex[0];
    } else {
        push @$components, $component;
        $id = $#$components;
    }

    my $isBootstrap = $cfg->isBootstrapFromResident();
    my $defaultColor = ($isBootstrap && $component->isServer()) ? wxLIGHT_GREY : $SYSTEM_BACKGROUND;
    my $color = $newLocation ? $COLOR_LIGHT_BLUE : $defaultColor;
    $self->{dialog}->updateComponentList($component, $id, $color, $isNewItem, $newLocation);
}

sub _getComponentList {
    my ( $self ) = @_;
    if ( not defined $self->{components} ) {
        $self->{components} = [];
    }
    return $self->{components};
}

sub _clearComponentList {
    my ( $self ) = @_;
    if ( defined $self->{components} ) {
        $self->{components} = [];
    }
}

sub hasDefaultDetectedComponents {
    my ($self) = @_;
    return $self->{_hasDefaultComponents};
}

1;