package LCM::Gui::Dialogs::AddHosts::AddHostsPanel;


use strict;
use parent 'LCM::Gui::Dialogs::HostsPanel';
use Wx qw (wxVERTICAL wxHORIZONTAL wxALIGN_CENTER_VERTICAL wxDefaultPosition wxTE_PASSWORD);
use LCM::Gui::DialogUtilities qw(GetAppConfig);
use LCM::HostsUtility qw ( IsHostPartOfSystem);

sub newFieldsSizer {
    my ($self) = @_;
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
    return $self->fieldsSizer($instconfig);
}

sub fieldsSizer {
    my ($self, $instconfig, ) = @_;
    my $window = $self->getWindow();
    my $sizer = new Wx::FlexGridSizer(3, 2, 5, 10);

    $window->{_fieldsSizer} = $sizer;
    $sizer->SetFlexibleDirection(wxHORIZONTAL);
    $sizer->AddGrowableCol(1);

    $self->_addParamInput('RootUser', $instconfig, $sizer);
    $self->_addParamInput('RootPassword', $instconfig, $sizer);
    $self->_addParamInput('Password', $instconfig, $sizer) if (IsHostPartOfSystem());
    $self->_addParamInput('HostagentPassword', $instconfig, $sizer);
    $self->_addAutoAddXs2RolesCheckBox($sizer, $instconfig);

    return $sizer;
}

sub _onAssignRoles {
	my ($self, $window) = @_;
	$self->SUPER::_onAssignRoles($window);
	$window->_handleAutoAddCheckBox();
}

sub _onRemoveHost {
	my ($self, $window) = @_;
	$self->SUPER::_onRemoveHost($window);
	$window->_handleAutoAddCheckBox();
}

sub _onEditHost {
	my ($self, $window) = @_;
	$self->SUPER::_onEditHost($window);
	$window->_handleAutoAddCheckBox();
}

sub _onAddHost {
	my ($self, $window) = @_;
	$self->SUPER::_onAddHost($window);
	$window->_handleAutoAddCheckBox();
}

sub setFieldProperties{
    my ($self,$instconfig) = @_;
    $self->_setParameterControlsVisibility($instconfig, 'RootUser');
}

sub newAddHostsSizer {
    my ( $self ) = @_;
    my $sizer = new Wx::BoxSizer(wxVERTICAL);
    $self->addHostsPanel($sizer);
    return $sizer;
}

1;