package LCM::Gui::Dialogs::Cockpit::ResumePendingCockpitOnHanaProps;
use strict;
use warnings;
use parent qw (LCM::Gui::Dialogs::Update::ResumePendingUpdatePropsDialog);
use Wx qw(wxEXPAND wxALIGN_CENTER_VERTICAL wxTE_PASSWORD);

use constant COCKPIT_TENANT_PWD => 'CockpitTenantUserPassword';

sub addCockpitTenantPwdPlaceholder{
    my ($self,$gridSizer,$config) = @_;
    my $paramStr=$config->getString(COCKPIT_TENANT_PWD);
    my $isMandatory = $config->isMandatory(COCKPIT_TENANT_PWD);
    my $label = SDB::Install::Gui::Control::Label->new($self, -1, $paramStr, $isMandatory);
    my $paramType = $config->isCockpitStackUpdate() ? 'passwd' : 'initial_passwd';
#check if cockpit tenant exist in order to get if confirmation of password is needed - this copies the behavoir of the CockpitTenantListener
#however this listener is still not triggered as the batch values are set in the Process of the dialog
    my $cockpitTenantPersValue=$config->getBatchValue('CockpitTenant');
    if ($cockpitTenantPersValue && !$config->getOwnInstance()->tenantExists($cockpitTenantPersValue)){
        $paramType = 'initial_passwd';
    }

    my $control = $self->_createUserInputControl($paramType, undef);
    $gridSizer->Add($label, 0, wxALIGN_CENTER_VERTICAL);
    $gridSizer->Add($control, 1, wxEXPAND);
    $self->{_uiControls}->{"_".COCKPIT_TENANT_PWD.LCM::Gui::Dialogs::GenericCredentialsDialog::LABEL} = $label;
    $self->{_uiControls}->{"_".COCKPIT_TENANT_PWD.LCM::Gui::Dialogs::GenericCredentialsDialog::CONTROL} = $control;
    if($paramType =~ /initial_passwd/){
        my $confirmationLabel = SDB::Install::Gui::Control::Label->new( $self, -1, "$paramStr Confirmation", $isMandatory);
        my $confirmationControl = new Wx::TextCtrl($self, -1, '', [-1,-1], [-1,-1], wxTE_PASSWORD);
        $gridSizer->Add($confirmationLabel,0, wxALIGN_CENTER_VERTICAL);
        $gridSizer->Add($confirmationControl, 1, wxEXPAND  );
        $self->{_uiControls}->{"_".COCKPIT_TENANT_PWD.LCM::Gui::Dialogs::GenericCredentialsDialog::CONFIRM_LABEL} = $confirmationLabel;
        $self->{_uiControls}->{"_".COCKPIT_TENANT_PWD.LCM::Gui::Dialogs::GenericCredentialsDialog::CONFIRM_CONTROL} = $confirmationControl;
    }
}

sub createControls{
    my ($self,$gridSizer,$config) = @_;
    $self->SUPER::createControls($gridSizer,$config);
    $self->addCockpitTenantPwdPlaceholder($gridSizer,$config);
}

sub Process{
    my $self = shift;
    if($self->SUPER::Process()){
        my $app = Wx::wxTheApp();
        my $instconfig = $app->getInstconfig();
        # set batch values for all the rest of the parameters, CockpitTenantPassword is the last parameter
        $instconfig->setBatchValueOfRequiredParams(COCKPIT_TENANT_PWD);
         if (!$instconfig->isSkipped(COCKPIT_TENANT_PWD)){
             return undef if(!$self->_setParameter($app, COCKPIT_TENANT_PWD, $instconfig));
         }
        return {};
    }
    return undef;
}

sub setBatchValueOfRequiredParams {
# set batch values up to OrgManagerPassword as it used for the creation of the XSClient
# XSClient is created in the CockpitSpaceListener, which in its order is after the OrgManagerPassword. 
#In GUI this listener is called in Process sub
    my ($self) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->getInstconfig();
    my $rc = $instconfig->setBatchValueOfRequiredParams('OrgManagerPassword');
    if (!defined $rc) {
        $app->ShowErrorMsg ('Initialize configuration failed', $instconfig->getErrMsgLst ());
    }
    return $rc;
}

1;