package LCM::Gui::Dialogs::Install::ExpressSystemPropertiesDialog;

use strict;
use LCM::Gui::DialogUtilities;
use parent qw(SDB::Install::Gui::Dialogs::GenericParameter);

sub new{
    my $class = shift();
    my $self = $class->SUPER::new(@_);

    $self->{id} = 'ExpressSystemProperties';
    $self->{name} = 'Define System Properties';
    $self->{label_text} = 'Specify the System Properties';

    return $self;
}

sub getParamKeys{
    return ['HostName', 'Target', 'SID', 'InstanceNumber'];
}


sub Process {
    my $self = shift();
    my $wizard = $self->GetWizard();
    my $application = Wx::wxTheApp();
    my $configuration = GetAppConfig();

    return undef if(!$self->SUPER::Process(@_));

    $configuration->resetError();

    for my $parameterId (@{$configuration->getParamIds()}){
        my $defaultValue = $configuration->getDefault($parameterId);
        my $batchValue = $configuration->getBatchValue($parameterId);
        my $targetValue = defined($batchValue) ? $batchValue : $defaultValue;
        my $isMapParameter = $configuration->getType($parameterId) =~ /map/;

        next if(!defined($targetValue));
        next if($configuration->hasValue($parameterId));
        next if($configuration->isSkipped($parameterId));
        next if($isMapParameter && ref($targetValue) eq 'ARRAY'); # Empty entry in config file generates an array with a single element - the empty string
        next if(!$isMapParameter && $self->_setValue($parameterId, $targetValue));
        next if($isMapParameter && $self->_setMapValues($parameterId, $targetValue));

        $application->ShowErrorMsg('Configuration error', $configuration->getErrMsgLst());
        return undef;
    }
    $wizard->RefreshSkippableDialogs();
    return {};
}

sub _setValue {
    my ($self, $parameterId, $value) = @_;
    my $configuration = GetAppConfig();

    if ($value =~ /\$/){
        $value = $configuration->substituteValues($value);
    }
    return $configuration->setValue($parameterId, $value);
}

sub _setMapValues {
    my ($self, $parameterId, $targetValue) = @_;
    my $configuration = GetAppConfig();

    for my $key (keys(%{$targetValue})){
        my $value = $targetValue->{$key};

        next if($configuration->setMapValueItem($parameterId, $key, $value));
        return undef;
    }
    return 1;
}

sub setBatchValueOfRequiredParams {
    my ($self) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->getInstconfig();
    my $rc = $instconfig->setBatchValueOfRequiredParams('HostName');
    if (!defined $rc) {
        $app->ShowErrorMsg ('Initialize configuration failed', $instconfig->getErrMsgLst ());
    }
    return $rc;
}
1;