package LCM::Gui::Dialogs::Install::ComponentProgressHandler;
use strict;
our @ISA = qw ( SDB::Install::Gui::Dialogs::PackageProgressHandler );
use SDB::Install::Gui::Dialogs::Install;
use LCM::Gui::Dialogs::UpdateHosts::ProgressHandler;
use SDB::Common::Utils qw( trim );

sub new {
    my $self = shift->SUPER::new (@_);
    $self->{label} = $_[1];
    $self->{id} = 'Install';
    return $self;
}

sub addLine{
    my ($self, $text) = @_;
    $self->{label}->SetLabel (trim($text));
    $self->SetProgress ($text);
}

package LCM::Gui::Dialogs::InstallDialog;
use strict;
use base qw ( SDB::Install::Gui::Dialogs::Install );
use LCM::Gui::TaskExecutionPlan;

use Wx qw ( wxEXPAND wxTOP wxALL wxLEFT wxVERTICAL wxALIGN_LEFT wxBOTTOM );
    
sub new{
    my($self ) = shift->SUPER::new(@_);
    my $top_sizer = Wx::BoxSizer->new(wxVERTICAL);
    $self->{'plan'} = LCM::Gui::TaskExecutionPlan->new($self,-1);
    $top_sizer->Add($self->{'caption'},0,wxALIGN_LEFT | wxLEFT | wxTOP , 20);
    $top_sizer->Add($self->{'plan'},1,wxALL | wxEXPAND, 20);
    $self->SetSizer($top_sizer);
    $self->SetAutoLayout(1);
    $self->Layout();
    return $self;
}
sub init{
    my ($self,$config) = @_;
    $self->GetWizard()->KillPreviousDialogs ();
    $self->GetWizard()->DisableNextDialog(); 

    $self->{progressLabel} = new Wx::StaticText ($self, -1, '');
    $self->GetSizer ()->Add($self->{progressLabel},0,wxEXPAND | wxLEFT | wxBOTTOM, 20);
    my $app               = Wx::wxTheApp();
    my $instconfig        = $app->getInstconfig();
    my $text;
    if ($instconfig->isUpdate()){
        $text = "Updating Software of System %s";
    } else{
        $text = "Installing Software of System %s ";
    }
    $self->{'caption'}->SetLabel (sprintf ($text, $instconfig->getValue ('SID')));
    return {'auto_next' => 1};

}

sub Process{
    my ($self,$config) = @_;

    my $app         = Wx::wxTheApp();
    my $instconfig  = $app->getInstconfig();
    my $logname     = 'hdblcmgui_';
    $logname       .= ($instconfig->isUpdate()) ? 'update' : 'install';

    $instconfig->dumpConfigFile('hdblcmgui');

    my $logSuffix   = $instconfig->getCustomLogSuffix();
    if ( !$app->defineLog($logname, $logname . ($logSuffix ? "_$logSuffix" : ""), $instconfig->isCheckOnly(), $instconfig->getSID())) {
        $app->ShowErrorMsg('Installation failed', $app->getErrMsgLst());
        return {'error_state' => 1};
    }

    my $process =  $app->getExecutor();
    $self->initProgressHandler($process);
   

    my $returnStatus = {};
    $process->execute();
    if(!$process->getStatus()->isInFinishedState()) {
        $app->ShowErrorMsg ('Installation failed', $process->getErrMsgLst());
        $returnStatus = {'error_state' => 1};
    }

    $app->handleExecutorMsgLst();
    return $returnStatus;
}

sub initProgressHandler() {
	my ($self, $process) = @_;
    my $componentProgressHandler = new LCM::Gui::Dialogs::Install::ComponentProgressHandler ($self->{plan}, $self->{progressLabel});
	my $processSteps = $process->getSubtasks();
	for my $subtask(@{$processSteps}){
		$subtask->addListener($componentProgressHandler);
	}
	$self->InitProgress( $processSteps );
}

sub InitProgress($$$$){
    my $self = shift();
    my ($tasks) = @_;
    $self->{'plan'}->init($tasks,{'with_progress' => 1});
    $self->GetWizard()->LayoutDlg();
    Wx::Yield ();
}

1;
