#!perl 
#===============================================================================
#
# Copyright (C) 2000 - 2014 by SAP AG,  http://www.sap.com.
# All rights reserved.
#
# This software is the confidential and proprietary information of SAP AG.
# You shall not disclose such confidential information and shall use it only
# in accordance with the terms of the license agreement you entered into with SAP.
#
#       AUTHOR: i072928
#

=head1 NAME

AlterHostPropsDialog

=head1 DESCRIPTION

Popup dialog for altering host properties.
=cut

#===============================================================================

package LCM::Gui::Dialogs::Rename::AlterHostPropsDialog;

use Wx qw (wxVERTICAL wxALL wxEXPAND wxALIGN_CENTER_VERTICAL wxOK wxCANCEL wxHORIZONTAL wxDefaultPosition wxID_OK wxTAB_TRAVERSAL);

use strict;
use SDB::Install::Gui::Design qw (SDBBGCOLOUR_WizardDialog);

our @ISA = qw (Wx::Dialog);

sub new {
	my ($class, $parent, $title, $label) = @_;
	my ($self) = $class->SUPER::new($parent, -1, $title ? $title : "Enter Target Host Name", wxDefaultPosition, new Wx::Size(450,150));

	$self->SetWindowStyleFlag($self->GetWindowStyleFlag | wxTAB_TRAVERSAL);
	$self->SetBackgroundColour (SDBBGCOLOUR_WizardDialog);
	
	# sizers
	my $outer_sizer = new Wx::BoxSizer(wxVERTICAL);
	$self->SetSizer($outer_sizer);
	
	my $sizer = new Wx::BoxSizer(wxVERTICAL);
	$outer_sizer->Add($sizer, 1, wxALL | wxEXPAND, 20);
	$self->{"inner_sizer"} = $sizer;
	
	my $inputFormSizer = $self->_createInputFormSizer($label);
	$sizer->Add($inputFormSizer, 1, wxEXPAND);
	
	my $buttonsSizer = $self->CreateButtonSizer(wxOK | wxCANCEL);
	$sizer->Add($buttonsSizer, 0, wxEXPAND);
	
	$self->_getOKButton()->Enable(1);
		
	return $self;
}

sub _createInputFormSizer {
	my ($self, $label) = @_;
	
	my $sizer = new Wx::FlexGridSizer( 1, 2, 5, 10 );
	$sizer->SetFlexibleDirection(wxHORIZONTAL);
	$sizer->AddGrowableCol(1);
	
	my $hostLbl = SDB::Install::Gui::Control::Label->new( $self, -1, $label ? $label : "Target Host Name", 1);
   	$sizer->Add($hostLbl, 0, wxALIGN_CENTER_VERTICAL);

	$self->{hostname} = new Wx::TextCtrl($self, -1, "");
	$self->{hostname}->SetFocus();
	$sizer->Add($self->{hostname}, 1, wxALIGN_CENTER_VERTICAL | wxEXPAND);
	
	return $sizer;
}

sub _getOKButton {
	my ($self) = @_;
	
	my $okBtn = Wx::Window::FindWindowById(wxID_OK, $self);
	return $okBtn;
}

sub GetHost() {
	my ($self) = @_;	
	return $self->{hostname}->GetValue();
}

sub SetHost() {
	my ($self, $host) = @_;	
	$self->{hostname}->SetValue($host);
}
