#!perl 
#===============================================================================
#
# Copyright (C) 2000 - 2014 by SAP AG,  http://www.sap.com.
# All rights reserved.
#
# This software is the confidential and proprietary information of SAP AG.
# You shall not disclose such confidential information and shall use it only
# in accordance with the terms of the license agreement you entered into with SAP.
#
#       AUTHOR: i072928
#

=head1 NAME

HDBUserPropertiesDialog

=head1 DESCRIPTION

HDB user parameters for the system rename scenario.
=cut

#===============================================================================
package LCM::Gui::Dialogs::Rename::HDBUserPropertiesDialog;

use strict;
our @ISA = qw (SDB::Install::Gui::Dialogs::GenericParameter);
use Wx qw(wxALIGN_CENTER_VERTICAL wxEXPAND wxTE_PASSWORD);
use Wx::Event qw (EVT_CHECKBOX);

sub new {
	my ($self) = shift()->SUPER::new(@_);

	my $instconfig = Wx::wxTheApp->{instconfig};
	my $instance = $instconfig->getOwnInstance();
	my $userString = "Database User";
	if(defined $instance && $instance->isMultiDb()){
		$userString =~ s/(?<!System\s)Database/System Database/g;
	}

	$self->{id}         = 'HDBUserPropertiesDialog';
	$self->{label_text} = "Enter $userString Properties";
	$self->{name}       = "Define $userString";

	return $self;
}

sub init {
	my $self = shift();
	my $returnValue = $self->SUPER::init(@_);
	EVT_CHECKBOX($self, $self->getParamCtrl('ChangeSystemPasswd')->GetId(), \&OnChangeSystemPasswd);
# Remove the auto_next property, because it creates a UI issue
	delete($returnValue->{auto_next});
	return $returnValue;
}

# Override to unskip the parameters in order to reuse the logic from the super class
sub createDialog {
	my ($self) = @_;
	my $rc = $self->SUPER::createDialog();
	$self->_enableControls($self->_isDbSystemPasswordChanged());
	return $rc;
}

sub getParamKeys {
    return ['ChangeSystemPasswd', 'SystemUser', 'SrcSQLSysPasswd', 'TrgSQLSysPasswd'];
}

sub Process {
	my ( $self, $config ) = @_;

	my $isEnabled = $self->getParamCtrl('ChangeSystemPasswd')->IsChecked();
	my $revertToSnapshot = Wx::wxTheApp()->getInstconfig()->getValue('RevertToSnapshot');
	if ( ! $isEnabled && !$revertToSnapshot) {
		return {};
	}

	return $self->SUPER::Process ( $config );
}

sub OnChangeSystemPasswd {
    my ($self) = @_;
    my $isEnabled = $self->getParamCtrl('ChangeSystemPasswd')->IsChecked();
    $self->_enableControls($isEnabled);
    return 1;
}

sub shouldCreateParamControl {
	return 1;
}

sub _enableControls {
	my ($self, $enable) = @_;
	my $app = Wx::wxTheApp();
	my $config = $app->getInstconfig();

	my $enableSourceDbCredentials = $config->getValue('RevertToSnapshot') || $enable;
	$self->toggleControlState($_, $enableSourceDbCredentials) foreach('SystemUser', 'SrcSQLSysPasswd');
	$self->toggleControlState('TrgSQLSysPasswd', $enable);

    $config->setValue('ChangeSystemPasswd', $enable ? 1 : 0);
}

sub _isDbSystemPasswordChanged() {
	return Wx::wxTheApp->{instconfig}->isDbSystemPasswordChanged ();
}

1;
