#!perl 
#===============================================================================
#
# Copyright (C) 2000 - 2014 by SAP AG,  http://www.sap.com.
# All rights reserved.
#
# This software is the confidential and proprietary information of SAP AG.
# You shall not disclose such confidential information and shall use it only
# in accordance with the terms of the license agreement you entered into with SAP.
#
#       AUTHOR: i072928
#

=head1 NAME

TargetUserDialog

=head1 DESCRIPTION

Set target OS user properties.
=cut

#===============================================================================
package LCM::Gui::Dialogs::Rename::TargetUserDialog;

use strict;
our @ISA = qw (SDB::Install::Gui::Dialogs::User);
use SDB::Install::Gui::Dialogs::User;
use SDB::Install::NewDBUser;
use SDB::Install::Gui::Design;

use Wx qw ( wxVERTICAL wxHORIZONTAL wxEXPAND wxLEFT wxALIGN_CENTER_VERTICAL wxDefaultPosition wxTE_PASSWORD);
use Wx::Event qw ( EVT_CHECKBOX );

sub new {
    my ( $self ) = shift->SUPER::new ( @_ );
    $self->{id} = 'TargetUserDialog';
    return $self;
}

#Override
sub init {
    my ( $self, $config ) = @_;
    my $instconfig = Wx::wxTheApp->{instconfig};
    my $targetSidadm = $instconfig->getSysAdminUserName($instconfig->getValue('newSID'));
    my $rc;
    
    if(!$self->isOsUserAlreadyExists($instconfig)) {
        $instconfig->{params}->{Password}->{value} = undef;  # no default value for the target OS user
        $instconfig->{username} = $targetSidadm;
        $rc = $self->SUPER::init ( @_ );
    } else {
        $self->{'label_text'} = "OS user for System Administrator $targetSidadm already exists. Enter $targetSidadm password";
        $rc = $self->_initWithPasswordParam($config, $instconfig);
    }    
    return $rc;
}

#Override
sub AddAdditionalParams {
    my ( $self, $instconfig ) = @_;
    $self->SUPER::AddAdditionalParams ( @_ );

    if(!$self->isOsUserAlreadyExists($instconfig) && $instconfig->isSIDChanged()) {
        $self->_addCheckBoxParam ( $instconfig, 'KeepUser' );
        $self->_addCheckBoxParam ( $instconfig, 'KeepUserHomeDir' );
        EVT_CHECKBOX($self, $self->{'KeepUser_chb'}->GetId(), \&OnKeepUserEvent);
    }

    return 1;
}

sub OnKeepUserEvent {
    my ($self) = @_;
    my $isChecked = $self->{'KeepUser_chb'}->IsChecked();
    $self->{'KeepUserHomeDir_chb'}->SetValue($isChecked);
    $self->{'KeepUserHomeDir_chb'}->Enable(!$isChecked);
}

sub _addCheckBoxParam {
    my ( $self, $instconfig, $paramName ) = @_;
    $self->SUPER::AddAdditionalParams ( @_ );

    my $param = $instconfig->{params}->{$paramName};
    my $paramLabel = new Wx::StaticText ( $self, -1, '' );
    $paramLabel->SetToolTip ( $param->{desc} );

    my $control = new Wx::CheckBox ( $self, -1, $param->{'str'}, [ -1, -1 ], [ -1, -1 ] );
    $control->SetToolTip ( $param->{desc} );
    $self->{ $paramName . '_chb' } = $control;

    $self->{'grid_sizer'}->Add ( $paramLabel, 0, wxALIGN_CENTER_VERTICAL );
    $self->{'grid_sizer'}->Add ( $control,    1, wxEXPAND );

    return 1;
}

#Override
sub Process {
    my ( $self, $config ) = @_;    
    my $instconfig = Wx::wxTheApp->{instconfig};    

    if(!$self->isOsUserAlreadyExists($instconfig)) {
        my $rc = $self->SUPER::Process ( $config );
        return $rc unless $rc;
        
        if($self->{'KeepUser_chb'}) {
            my $valueKeepUser = $self->{'KeepUser_chb'}->GetValue ();
            $valueKeepUser = ($valueKeepUser) ? 1 : 0;
            $instconfig->setValue ( 'KeepUser', $valueKeepUser );
        }

        if($self->{'KeepUserHomeDir_chb'}) {
            my $valueKeepDir = $self->{'KeepUserHomeDir_chb'}->GetValue ();
            $valueKeepDir = ($valueKeepDir) ? 1 : 0;
            $instconfig->setValue ( 'KeepUserHomeDir', $valueKeepDir );
        }
    } else {        
        my $rc = $self->_validatePasswordParam($instconfig);
        return $rc unless $rc;
    }

    return {};
}

sub _initWithPasswordParam {
    my ($self, $config, $instconfig) = @_;
    my $is_gtk1 =  Wx::wxGTK1();
    
    my $sizer = Wx::BoxSizer->new(wxVERTICAL);
    
    $sizer->AddSpacer (16);
    $self->{'titel_big'} = Wx::StaticText->new($self, -1, $self->{label_text});
    $self->{'titel_big'}->SetFont( SDBFONT_DialogTitle ) if (!$is_gtk1);
    $sizer->Add($self->{'titel_big'},0, wxLEFT , 16 );
    $sizer->AddSpacer (16);
    
    my $paramSizer = $self->_addPasswordParam($instconfig);
    
    $sizer->Add($paramSizer, 0, wxLEFT , 20 );
    $self->SetSizerAndFit($sizer);
    $self->SetAutoLayout(1);
    $self->Layout();
    $self->Show(1);
    
    return {};
}

sub _addPasswordParam {
    my ($self, $instconfig) = @_;
    
    my $param = $instconfig->{params}->{'Password'};
    my $sizer = new Wx::FlexGridSizer ( 1, 2, 5, 10 );
    $sizer->SetFlexibleDirection ( wxHORIZONTAL );
    $sizer->AddGrowableCol ( 1 );
    
    my $label = SDB::Install::Gui::Control::Label->new ( $self, -1, $param->{str}, $param->{mandatory});
    $label->SetToolTip ( $param->{desc} );

    my $control = new Wx::TextCtrl ( $self, -1, $param->{value}, wxDefaultPosition, [ 200, -1 ], wxTE_PASSWORD);
    $control->SetToolTip ( $param->{desc} );
    $self->{passwordControl} = $control;

    $sizer->Add ( $label,   0, wxALIGN_CENTER_VERTICAL );
    $sizer->Add ( $control, 0, wxALIGN_CENTER_VERTICAL);
    
    return $sizer;
}

sub _validatePasswordParam {
    my ($self, $instconfig) = @_;
    my $app = Wx::wxTheApp;
    my $passwordControl = $self->{"passwordControl"};
    my $value = $passwordControl->GetValue();
    my $msgLst = new SDB::Install::MsgLst ();
    my $rc = $instconfig->setValue ( 'Password', $value, $msgLst );
    unless($rc) {
        $msgLst->addError ( 'Error while trying to verify the System Administrator password.' );
        $app->ShowErrorMsg ( 'Configuration error', $msgLst );
        return undef;
    }
    return 1;
}

sub isOsUserAlreadyExists {
    my ($self, $instconfig) = @_;
    my $osUser = new SDB::Install::NewDBUser ($instconfig->{params}->{newSID}->{value});
    return $osUser->exists();
}

1;
