package LCM::Gui::Dialogs::SAPDSignerVerificationDialog;
use strict;
use warnings;
use parent qw(SAPDB::Install::Wizard::Dialog::Base);

use Wx qw(wxVERTICAL wxALIGN_LEFT wxEXPAND wxALL wxHORIZONTAL wxLEFT);

sub SetProgress {
    my ($self, $value) = @_;
    my $progressSizer = $self->getSAPDSignerProgressSizer();
    return if (!defined $progressSizer);
    my $gauge = $self->getProgressGauge();
    return if (!defined $gauge);

    $value = 100 if ($value > 100);
    $gauge->SetValue($value);
    Wx::Yield();
}

sub addProgressSizer {
    my ($self) = @_;
    return if (defined $self->getSAPDSignerProgressSizer());
    my $progressSizer = $self->_createSAPDSignerProgressSizer();

    $self->setSAPDSignerProgressSizer($progressSizer);
    my $sizer = $self->GetSizer();
    if (!defined $sizer) {
# This handles cases when we try to add a progress sizer before
# the acctual dialog UI is rendered. For example in GenericParameter dialogs
# where SelectedComponents can be set before creating the dialog itself.
        $sizer = Wx::BoxSizer->new(wxVERTICAL);
        $sizer->Add($progressSizer, 1, wxALIGN_LEFT | wxEXPAND | wxALL, 20);
        $self->SetSizerAndFit($sizer);
        $self->GetWizard()->LayoutDlg();
    } else {
        $self->GetSizer()->Add($progressSizer, 0, wxALIGN_LEFT | wxEXPAND | wxALL, 20);
    }
}

sub _createSAPDSignerProgressSizer {
    my ($self) = @_;
    my $progressInfoSizer = Wx::BoxSizer->new(wxVERTICAL);
    $self->setProgressGauge(Wx::Gauge->new($self, -1, 100));
    $self->setProgressMessageLabel(Wx::StaticText->new($self, -1, ''));

    my $gaugeSizer = Wx::BoxSizer->new(wxHORIZONTAL);
    $gaugeSizer->Add($self->getProgressGauge(), 1, wxALIGN_LEFT);
    $progressInfoSizer->Add($gaugeSizer, 0, wxALIGN_LEFT | wxEXPAND);
    $progressInfoSizer->Add($self->getProgressMessageLabel(), 0, wxALIGN_LEFT);
    return $progressInfoSizer;
}

sub setSAPDSignerProgressSizer {
    my ($self, $sizer) = @_;
    $self->{sapdsignerProgressSizer} = $sizer;
}

sub getSAPDSignerProgressSizer {
    my ($self) = @_;
    return $self->{sapdsignerProgressSizer};
}


sub setProgressGauge {
    my ($self, $gauge) = @_;
    $self->{progressGauge} = $gauge;
}

sub getProgressGauge {
    my ($self) = @_;
    return $self->{progressGauge};
}

sub setProgressMessageLabel {
    my ($self, $label) = @_;
    $self->{progressMessage} = $label;
}

sub getProgressMessageLabel {
    my ($self) = @_;
    return $self->{progressMessage};
}

sub showSAPDSignerProgressSizer {
    my ($self, $shouldShow) = @_;
    $shouldShow //= 1;
    $self->GetSizer()->Show($self->getSAPDSignerProgressSizer(), $shouldShow, 1);
    $self->Layout();
}

sub setWasElementEnabled {
    my ($self, $element, $bool) = @_;
    $self->{elementState} //= {};
    $self->{elementState}->{$element->GetId()} = $bool;
}

sub getWasElementEnabled {
    my ($self, $element) = @_;
    return undef if (!defined $self->{elementState});
    return $self->{elementState}->{$element->GetId()};
}

sub enableNonProgressSizerUIControls {
    my ($self, $bool, $sizer) = @_;
    $sizer //= $self->GetSizer();
    for my $item ($sizer->GetChildren()) {
        if ($item->IsSizer()) {
            $self->enableNonProgressSizerUIControls($bool, $item->GetSizer());
        } elsif ($item->IsWindow()) {
            my $windowItem = $item->GetWindow();
            my $isProgressGauge        = $windowItem->GetId() == $self->getProgressGauge()->GetId();
            my $isProgressMessageLabel = $windowItem->GetId() == $self->getProgressMessageLabel()->GetId();
            next if ($isProgressGauge || $isProgressMessageLabel);
            if (!$bool) {
                my $isEnabled = ($windowItem->IsEnabled()) ? 1 : 0;
                $self->setWasElementEnabled($windowItem, $isEnabled);
            } else { # don't re-enable if disabled beforehand
                my $wasEnabled = $self->getWasElementEnabled($windowItem);
                next if (defined $wasEnabled && !$wasEnabled);
            }
            $windowItem->Enable($bool);
        } else {
            next;
        }
    }
}

1;