package LCM::Gui::Dialogs::SelectActivityExternalDialog;

use strict;

use Wx qw (wxVERTICAL wxHORIZONTAL wxTOP wxLEFT wxRIGHT wxDefaultPosition wxDefaultSize wxALIGN_CENTER_VERTICAL wxEXPAND wxALL wxOK wxCENTRE wxICON_INFORMATION);
use SDB::Install::Gui::Design;
use Wx::Event qw (EVT_RADIOBUTTON EVT_COMBOBOX);
use LCM::Gui::Dialogs::PendingSummaryDialog;
use LCM::Gui::Dialogs::SelectComponentsForInstallDialog;
use SDB::Install::Gui::Dialogs::VolumePaths;
use SDB::Install::Gui::Dialogs::User;
use SDB::Install::Gui::Dialogs::SQLUser;
use LCM::Gui::Dialogs::SummaryDialog;
use LCM::Gui::Dialogs::InstallDialog;
use LCM::Gui::Dialogs::FinalizeDialog;
use LCM::Gui::Dialogs::SelectComponentsForUpdateDialog;
use LCM::Gui::Dialogs::FinalizeCockpitInstallationDialog;
use SDB::Install::Globals qw($gKeynameEngine $gProductNameEngine);
use LCM::Gui::Dialogs::SelectComponentsDialog;
use LCM::Gui::Dialogs::ResumePendingInstallPropertiesDialog;
use LCM::Gui::Dialogs::LSSPropertiesDialog;
use LCM::PersistencyUtils qw (getPendingUpdateSIDs existsHdblcmPendingUpdate);
use SDB::Install::SAPSystem qw (CollectSAPSystems);
use LCM::Configuration::GenericStackUpdateConfiguration qw($unableToContinueUpdateMsg);
use LCM::Configuration::GenericStackAny qw(INSTALL_ACTION);
use LCM::Task::GenericStackTask::InstallProcessTask;
use LCM::Task::GenericStackTask::UpdateProcessTask;
use LCM::Gui::Dialogs::UiComponentsFactory qw(CreateTitle CreateRadioButton CreateComboBox);
use LCM::Gui::Dialogs::SelectComponentsForUpdateDialog;

use parent qw(LCM::Gui::Dialogs::SelectActivityDialog LCM::Gui::Dialogs::SAPDSignerVerificationDialog);

sub new {
    my($self) = shift->SUPER::new(@_);
    
    $self->{id} = 'SelectActivityExternal';
	$self->{name} = "Select Activity";
	
    my $outersizer = new Wx::BoxSizer (wxVERTICAL);
    my $innerSizer = new Wx::BoxSizer (wxVERTICAL);
    $outersizer->Add($innerSizer, 1, wxALL | wxEXPAND, 20);
    my $leftInnerSizer = new Wx::BoxSizer(wxVERTICAL);
    $self->{leftInnerSizer} = $leftInnerSizer;

	my $is_gtk1 = Wx::wxGTK1 ();
	$self->{'title'} = CreateTitle($self, 'Choose system to update, or choose installation', $is_gtk1);
    $innerSizer->Add($self->{'title'}, 0);

    $self->createSystemsControls();
	my $descriptionSizer = $self->_createDescriptionSizer ();
	my $innerHorizontalSizer = new Wx::GridSizer(1, 2, 0, 70);

	$innerHorizontalSizer->Add($leftInnerSizer, 1, wxEXPAND);
	$innerHorizontalSizer->Add($descriptionSizer, 1, wxEXPAND);
	$innerSizer->Add ($innerHorizontalSizer, 1, wxEXPAND | wxTOP, 30);

	$self->SetSizer($outersizer);
	$self->SetAutoLayout (1);
    return $self;
}

sub createSystemsControls{
    my($self) = @_;
    my $is_gtk1 = Wx::wxGTK1 ();
    my $existingInstallations = $self->getExistingInstallations ();
    my $existsInstallations = scalar @{$existingInstallations} > 0;
    my $updateSIDs = $self->_getUpdateSIDs();
    my $existsUpdateSIDs = (scalar @{$updateSIDs}) > 0;

    if ($existsUpdateSIDs || !$existsInstallations) {
        $self->_createUpdateControls( $is_gtk1 );
    }

    if ( $self->{_existsPendingInstall} ){
        $self->_createPendingInstallationControls( $is_gtk1 );
    }

    $self->_createInstallControls( $is_gtk1 );
}

sub _createUpdateControls {
	my ( $self, $is_gtk1 ) = @_;
	my $leftInnerSizer = $self->{leftInnerSizer};

	$self->{'rb_update'} = CreateRadioButton($self, "&Update existing system",  $is_gtk1 );
    $leftInnerSizer->Add( $self->{'rb_update'}, 0, wxEXPAND|wxRIGHT, 20 );
    $leftInnerSizer->AddSpacer( 12 );
    EVT_RADIOBUTTON( $self, $self->{'rb_update'}->GetId(), \&OnRBUpdate );

    $self->{'lb_installations'} = new Wx::StaticText( $self,-1,"Select system:", wxDefaultPosition, wxDefaultSize );
    $self->{'cb_installations'} = CreateComboBox($self, '', $is_gtk1, new Wx::Size(100, -1), new Wx::Size(100, -1));
    EVT_COMBOBOX( $self, $self->{'cb_installations'}->GetId(), \&OnComboBoxUpdate );

    my $update_sizer = new Wx::BoxSizer( wxHORIZONTAL );
    $update_sizer->Add( $self->{'lb_installations'},0, wxALIGN_CENTER_VERTICAL );
    $update_sizer->Add( $self->{'cb_installations'},0,  wxLEFT | wxRIGHT,10 );
    
    $leftInnerSizer->Add( $update_sizer, 0 , wxLEFT, 20 );
    $leftInnerSizer->AddSpacer( 30 );

    $self->{_isUpdateCtrlsCreated} = 1;
}

sub _createInstallControls {
    my ( $self, $is_gtk1 ) = @_;
    my $leftInnerSizer = $self->{leftInnerSizer};

    $self->{'rb_install'} = CreateRadioButton($self, "&Install New System", $is_gtk1); 
    $leftInnerSizer->Add($self->{'rb_install'},0, wxEXPAND|wxRIGHT, 20);
    $leftInnerSizer->AddSpacer(30);
    EVT_RADIOBUTTON ($self, $self->{'rb_install'}->GetId(), \&OnRBInstall);
}

sub _createPendingInstallationControls {
    my ( $self, $is_gtk1 ) = @_;
    my $leftInnerSizer = $self->{leftInnerSizer};

    $self->{'rb_pendingInstall'} = CreateRadioButton($self, "&Resume pending installation", $is_gtk1);
    $leftInnerSizer->Add($self->{'rb_pendingInstall'},0, wxEXPAND|wxRIGHT, 20);
    $leftInnerSizer->AddSpacer(12);
    EVT_RADIOBUTTON ($self, $self->{'rb_pendingInstall'}->GetId(), \&OnRBPendingInstall);

    $self->{'label_pendingInstall'} = new Wx::StaticText( $self,-1,"Select system:", wxDefaultPosition, wxDefaultSize );
    $self->{'combo_pendingInstall'} = CreateComboBox($self, '', $is_gtk1, new Wx::Size(100, -1), new Wx::Size(100, -1));
    EVT_COMBOBOX($self, $self->{'combo_pendingInstall'}->GetId(), \&OnComboBoxPendingInstall);

    my $pendingInstallSizer = new Wx::BoxSizer(wxHORIZONTAL);
    $pendingInstallSizer->Add( $self->{'label_pendingInstall'},0, wxALIGN_CENTER_VERTICAL );
    $pendingInstallSizer->Add( $self->{'combo_pendingInstall'},0, wxLEFT | wxRIGHT,10 );

    $leftInnerSizer->Add($pendingInstallSizer, 0 , wxLEFT, 20);
    $leftInnerSizer->AddSpacer( 30 );

    $self->{_isPendingInstallCtrlsCreated} = 1;
}

sub init{
	my ($self,$config) = @_;

   	my $existingInstallations = $self->getExistingInstallations ();
	my $existsInstallations = (scalar @{$existingInstallations}) > 0;
	my $updateSIDs= $self->_getUpdateSIDs();

	my $app = Wx::wxTheApp();
	my $actionConfig = $app->getActionConfiguration();
	my $mediumComponentManager = $actionConfig->getComponentManager ();

	if ($existsInstallations) {
		$self->{'title'}->SetLabel( 'Choose system to update, or choose installation' );
	}

    if ($self->{_isUpdateCtrlsCreated}) {
    	if(!$self->{'isUpdateInitialized'}) {
			$self->_enableUpdateUi(1);
			$self->_appendUpdates($updateSIDs);
            $self->{'rb_update'}->Enable (1);
    	}
    }

    if (!$existsInstallations) {
        $self->{'rb_install'}->SetValue (1);
        $self->{'rb_update'}->Enable (0);
		$self->_showUpdateUi(0);
        $self->{'title'}->SetLabel( "Install new ".$actionConfig->getProductName()." System" );
    }

    if ($self->{_existsPendingInstall} && !$self->{'isPendingInstallInitialized'}) {
		my $pendingInstallSIDs = $self->_getPendingInstallSIDs();
		$self->_appendPendingInstallations($pendingInstallSIDs);
    }

    if (!defined $mediumComponentManager || !$mediumComponentManager->hasComponents ()){
        $app->ShowErrorMsg ('No component found', defined $mediumComponentManager ? $mediumComponentManager->getErrMsgLst() : undef);
        return undef;
    }
    $app->getMsgLst()->appendMsgLst ($mediumComponentManager->getMsgLst ());
    $mediumComponentManager->setMsgLstContext( [ $app->getMsgLst() ] );

	$self->_setUiAction($actionConfig);
    $self->Layout();

    if ($self->_isActionGivenViaCommandLine()) {
        return {auto_next => 1};
    }
	return {};
}

sub _isActionGivenViaCommandLine {
    my ($self) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->getActionConfiguration();
    my $cmdLineActionValue = $instconfig->getCommandLineValue('Action');
    my $cmdLineSidValue = $instconfig->getCommandLineValue('Action_SID');
    my $installedSystemsComboboxSelection = $self->{cb_installations}->GetStringSelection();

    if (defined $cmdLineSidValue && $cmdLineActionValue eq 'update' && $cmdLineSidValue eq $installedSystemsComboboxSelection) {
         return 1;
    }
    return 0;
}

sub getExistingInstallations {
    my ($self) = @_;

    if (defined $self->{_installedSIDs}) {
    	return $self->{_installedSIDs};
    }

    my $app = Wx::wxTheApp;
    my $configuration = $app->getInstconfig();
	my $actionConfig = $app->getActionConfiguration();
	my $systemsCollection = $actionConfig->getSystemCollection();
	my @lssPendingInstallations = $systemsCollection->getLSSPendingInstallations();
	my @installedSid = $systemsCollection->getInstalledSystems();
    my @pendingInstallations = $systemsCollection->getPendingInstallations();

	$self->{_installedSIDs} = \@installedSid;
	$self->{_pendingInstallSystems} = \@pendingInstallations;
	$self->{_pendingLSSInstallationSIDs} = \@lssPendingInstallations;
	$self->{_existsPendingInstall} = scalar @{$self->{_pendingInstallSystems}} > 0 || scalar @{$self->{_pendingLSSInstallationSIDs}} > 0;

	return $self->{_installedSIDs};
}

sub _getPendingInstallSIDs {
    my ($self) = @_;

    if (!defined $self->{_pendingInstallSystems} || !defined $self->{_pendingLSSInstallationSIDs}) {
		$self->getExistingInstallations();
    }

	my $pendingInstallations = $self->{_pendingInstallSystems};
	my @pendingInstallSIDs = ();

	for my $currPendingSID (@{$pendingInstallations}) {
		push @pendingInstallSIDs, $currPendingSID;
	}

	for my $currentSID (@{$self->{_pendingLSSInstallationSIDs}}) {
        push @pendingInstallSIDs, $currentSID;
    }

	return \@pendingInstallSIDs;
}

sub _getUpdateSIDs {
	my ($self) = @_;

	if (defined $self->{_updateSIDs}) {
		return $self->{_updateSIDs};
	}

	my $existingInstallations = $self->getExistingInstallations ();
	my @updateSIDs = ();

	foreach my $existingInstalledSid (@$existingInstallations) {
		push @updateSIDs, $existingInstalledSid;
	}

	$self->{_updateSIDs} = \@updateSIDs;
	return \@updateSIDs;
}

sub _appendUpdates {
	my ($self, $updateSIDs) = @_;

	for my $row (@{$updateSIDs}){
		$self->{'cb_installations'}->Append($row);
	}
	$self->{'isUpdateInitialized'} = 1;
 	$self->{'cb_installations'}->SetSelection(0);
}

sub _appendPendingInstallations {
	my ($self, $pendingInstallSIDs) = @_;

	for my $currPendingSID (@{$pendingInstallSIDs}) {
        $self->{'combo_pendingInstall'}->Append($currPendingSID);
    }
    $self->{'isPendingInstallInitialized'} = 1;
    $self->{'combo_pendingInstall'}->SetSelection(0);
}

sub _enableUpdateUi {
	my ($self, $enable) = @_;
	return if ! $self->{_isUpdateCtrlsCreated};

	$self->{'lb_installations'}->Enable($enable) if defined $self->{'lb_installations'};
    $self->{'cb_installations'}->Enable($enable) if defined $self->{'cb_installations'};
}

sub _showUpdateUi {
	my ($self, $enable) = @_;
	return if ! $self->{_isUpdateCtrlsCreated};

    $self->{'rb_update'}->Show($enable);
	$self->{'lb_installations'}->Show($enable);
    $self->{'cb_installations'}->Show($enable);
}

sub _showPendingInstallUi {
	my ($self, $show) = @_;
	return if ! $self->{_isPendingInstallCtrlsCreated};

	$self->{'rb_pendingInstall'}->Show($show);
    $self->{'label_pendingInstall'}->Show($show);
    $self->{'combo_pendingInstall'}->Show($show);
}

sub _enablePendingInstallUi {
	my ($self, $enable) = @_;
	return  if ! $self->{_isPendingInstallCtrlsCreated};

	$self->{'label_pendingInstall'}->Enable($enable);
    $self->{'combo_pendingInstall'}->Enable($enable);
}

sub _setUiAction {
	my ($self, $instconfig) = @_;

	my $paramAction = $instconfig->getParamByOpt('action');
	if(defined $paramAction->{value}) {
		$self->_setComandLineAction($paramAction->{value});
	} else {
		$self->_setDefaultAction();
	}
}

sub _setComandLineAction {
	my ($self, $action) = @_;

    if ($action eq 'update') {
    	$self->_setConcreteUpdateRadioButton();
    } else {
		$self->_selectInstall();
    }
}

sub _setConcreteUpdateRadioButton {
	my ($self) = @_;

	my $app = Wx::wxTheApp();
	my $instconfig = $app->getActionConfiguration();
	# Batch value is set even if the tool is not started in batch mode
	my $sid = $instconfig->{params}->{Action_SID}->{batchValue}; 

	if (!defined $sid) {
		$self->_setDefaultAction();
		return;
	}
	$self->_selectUpdate();
}

sub _setDefaultAction {
	my ($self) = @_;
	if ($self->{_isUpdateCtrlsCreated} && (scalar @{$self->{_installedSIDs}} > 0)) {
        $self->_selectUpdate();
        return;
    }
    if ($self->{_isPendingInstallCtrlsCreated}) {
    	$self->_selectPendingInstall();
    	return;
    }
	$self->_selectInstall();
}

sub _setSidValueToUpdateComboBox {
	my ($self, $cb_SIDs) = @_;

	if (!defined $cb_SIDs) {
		return undef;
	}

	my $app = Wx::wxTheApp();
    my $instconfig = $app->getActionConfiguration();
    # Batch value is set even if the tool is not started in batch mode
    my $sid = $instconfig->{params}->{Action_SID}->{batchValue}; 
    if (defined $sid) {
    	my @systems = $cb_SIDs->GetStrings();
    	my $index = -1;    	
    	for (@systems) {
    		$index+=1;
    		if ($_ eq $sid) {
    			$cb_SIDs->SetSelection($index);
    			return 1;
    		}
    	}
    }

    return undef;
}

sub Process {
    my ($self, $config) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->getActionConfiguration();
    my $wizard = $self->GetWizard ();

    $self->_initSelectedAction();
    $wizard->resetController();

    if ($self->_isInstall() || $self->_isPendingInstall()) {
        if(!$self->_isServerAvailable()) {
            $instconfig->setErrorMessage("$gProductNameEngine was not detected from the provided resources.");
            $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
            return {'errstate' => 1};
        }
        if ($self->_isPendingInstall()) {
            my $sid = $self->{combo_pendingInstall}->GetValue();
            $app->getActionConfiguration()->setValue('Action_SID', $sid);
        }
        $instconfig = $app->createConfiguration('install');
    } elsif ($self->_isUpdate() || $self->_isPendingUpdate()) {
# Make sure that Action_SID is set, because this will trigger the needed call for preparing the
# execution environment in case of sidadm execution. This might result in repeated values in LD_LIBRARY_PATH
# in case of Next->Back->Next !!!!
        $app->getActionConfiguration()->setValue('Action_SID', $self->getSelectedSID());
        $instconfig = $app->createConfiguration('update');
    }

    $app->setInstconfig($instconfig);

    my $executor = $self->createExecutor($instconfig);
    $app->setExecutor($executor);


    if ($self->_isUpdate() || $self->_isPendingUpdate()) {
        if (!$instconfig->setValue('SID', $self->getSelectedSID())) {
            $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
            return undef;
        }
        if($self->_isPendingUpdate()){
            my $pendingConfig = $instconfig->getPendingConfiguration();
            if ($pendingConfig){
                my $msg = $pendingConfig->getErrorString();
                Wx::MessageBox($unableToContinueUpdateMsg."\n".$msg , "Info", wxOK | wxCENTRE | wxICON_INFORMATION, $self )if ($msg);
            }
        }
    }

    $instconfig->setPendingInstallation(0);
    if ($self->_isPendingInstall()) {
        my $sid = $self->{combo_pendingInstall}->GetValue();
        $app->getActionConfiguration()->setValue('Action_SID', $sid);

        $instconfig->setPendingInstallation(1);
        my $sapSystems = CollectSAPSystems();
        if( defined $sapSystems->{$sid} ){
            $instconfig->{params}->{Target}->{value} = $sapSystems->{$sid}->get_target();
        }
        $instconfig->{current_sid} = $sid;
        $instconfig->{params}->{SID}->{value} = $sid;
        if(!$instconfig->handlePendingInstall($sid)) {
            $app->ShowErrorMsg('Error', $instconfig->getErrMsgLst());
            return { errstate => 1 };
        }
    }

    if (!$instconfig->InitDefaults()) {
        $app->ShowErrorMsg("Fatal Error", $instconfig->getErrMsgLst());
        return undef;
    }

    if (!$instconfig->CheckParams(0)) {
        $app->ShowErrorMsg ('Error', $instconfig->getErrMsgLst());
        return {errstate => 1};
    }

    if (!$app->getCLIParser()->parse(0)) {
        return {'errstate' => 1};
    }

    my $oldcontext = $instconfig->setMsgLstContext($app->getMsgLstContext());
    if (!defined $instconfig->checkSystemRequirements ($app->GetSysInfo())){
        if ($instconfig->getIgnore ('check_hardware')){
           $app->{msglst}->addMessage ("Ignoring error due to command line switch '--ignore=check_hardware'");
        }
        else{
           $app->ShowErrorMsg ('Installation failed', $instconfig->getErrMsgLst());
           return {'errstate' => 1};
        }
    }
    $instconfig->setMsgLstContext($oldcontext);

    if ( $self->_isPendingInstall() && ! $instconfig->validatePersistency() ) {
        $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
        return {'errstate' => 1};
    }

    $self->_addGuiDialogsInWizard();

    return {};
}

sub shouldAddCondensedSteps {
	my ($self) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->getInstconfig();
    if($self->_isPendingUpdate()){
        return 1 if(!$instconfig->canContinueUpdate());
        return 0 if ($self->_isPendingUpdate() && existsHdblcmPendingUpdate($self->getSelectedSID()));
    }
	return 0 if ($self->_isPendingInstall());
	return 1;
}

sub addPendingUpdateNextDialog{
    my ($self, $wizard) = @_;
    my $nextDialog;
    if (!$self->shouldAddCondensedSteps()){
        $nextDialog = new LCM::Gui::Dialogs::PendingSummaryDialog($wizard);
        $wizard->AddDialog ($nextDialog);
    } else {
        my $app = Wx::wxTheApp;
        my $instconfig = $app->getInstconfig();
        $instconfig->setValue('ContinueUpdate', 0);
        $nextDialog = new LCM::Gui::Dialogs::SelectComponentsForUpdateDialog ($wizard);
        $wizard->AddDialog ($nextDialog);
    }
    $self->SetNext($nextDialog);
}

sub _addCondensedSteps {
    my ($self,$wizard) = @_;

	my $controller = $wizard->getController();
	my $previousDialogId = $self->GetNext()->GetID();
	$wizard->ResetCondensedStep('input');
	my $condensedSteps = $controller->getCondensedSteps();
	my $mapDialogIdToSkipPredicates = $controller->getMapDialogIdToSkipPredicates();

	foreach my $dialog (@{$condensedSteps}){
		$wizard->InsertDialog ($dialog, $previousDialogId, 'input', $mapDialogIdToSkipPredicates->{$dialog->GetID()});
		$previousDialogId = $dialog->GetID();
	}
}

sub _initSelectedAction {
    my ($self) = @_;
    my $app = Wx::wxTheApp;
	my $actionConfig = $app->getActionConfiguration();
	$actionConfig->setPendingInstallation(0);

	$self->_setInstall(0);
	$self->_setPendingInstall(0);
	$self->_setUpdate(0);
	$self->_setPendingUpdate(0);
	if ( defined $self->{'rb_install'} && $self->{'rb_install'}->GetValue() ) {
		$self->_setInstall(1);
	} elsif ( defined $self->{'rb_pendingInstall'} && $self->{'rb_pendingInstall'}->GetValue() ) {
		$self->_setPendingInstall(1);
		$actionConfig->setPendingInstallation(1);
	} elsif ( defined $self->{'rb_update'} && $self->{'rb_update'}->GetValue() ) {
        $self->_setUpdate(1);
	}

}

sub _setInstall {
	$_[0]->{_isInstall} = $_[1];
}

sub _isInstall {
	return $_[0]->{_isInstall};
}

sub _setUpdate {
    my($self,$value) = @_;
    if($value){
        my $selectedSid = $self->getSelectedSID();
        my $isPending = $self->getSystemCollection()->isInstalledSystemPendingUpdate($selectedSid);
        my $isPendingUpdateIgnored = grep { $_ =~ /check_pending_upgrade/} @ARGV;
        if($isPending && !$isPendingUpdateIgnored){
            $self->_setPendingUpdate(1);
            $self->{_isUpdate} = 0;
            return;
        }
    }
	$self->{_isUpdate} = $value;
}

sub _isUpdate {
	return $_[0]->{_isUpdate};
}

sub _setPendingInstall {
	$_[0]->{_isPendingInstall} = $_[1];
}

sub _isPendingInstall {
	return $_[0]->{_isPendingInstall};
}

sub _setPendingUpdate {
	$_[0]->{_isPendingUpdate} = $_[1];
}

sub _isPendingUpdate {
	return $_[0]->{_isPendingUpdate};
}

sub _addGuiDialogsInWizard {
	my ($self) = @_;

	my $wizard = $self->GetWizard ();
    $wizard->unterminateChain();
	if($self->_isPendingUpdate()){
        $self->addPendingUpdateNextDialog($wizard);
	} else  {
		$self->addNonPendingUpdateNextDialog($wizard);
	}
	if ( $self->shouldAddCondensedSteps()) {
        $wizard->AddCondensedStep('input','Configure');
    }

    $self->addSummaryExecutionDialogs($wizard);

    my $installDialog = new LCM::Gui::Dialogs::InstallDialog ($wizard);
    $installDialog->{name} = "Execute";
    $wizard->AddDialog ($installDialog);
    $self->addExecutionFinalizeDialogs($wizard);
	$wizard->terminateChain();

    if ( $self->shouldAddCondensedSteps()) {
        $self->_addCondensedSteps($wizard);
    }

    $wizard->init();
}

sub addSummaryExecutionDialogs{
    my ($self, $wizard) = @_;
    my $instconfig = Wx::wxTheApp()->getInstconfig();

    if ($self->_isPendingUpdate() && existsHdblcmPendingUpdate($self->getSelectedSID()) && $instconfig->canContinueUpdate()){
        $wizard->AddDialog (new LCM::Gui::Dialogs::PendingSummaryDialog($wizard));
    } else {
        $wizard->AddDialog (new LCM::Gui::Dialogs::SummaryDialog ($wizard));
    }
}

sub addExecutionFinalizeDialogs {
	my ($self, $wizard) = @_;
    $wizard->AddDialog (new LCM::Gui::Dialogs::FinalizeDialog ($wizard));
}

sub addNonPendingUpdateNextDialog {
	my ($self,$wizard) = @_;

	my $controller = $wizard->getController();
	my $skipSelectedComponentsDialogSub = $controller->getMapDialogIdToSkipPredicates()->{'SelectComponents'};
	my $shouldSkipSelectComponentsDialog = defined $skipSelectedComponentsDialogSub && &$skipSelectedComponentsDialogSub;
    my $nextDialog;
	$nextDialog = new LCM::Gui::Dialogs::ResumePendingInstallPropertiesDialog ($wizard) if $self->_isPendingInstall();
    $nextDialog = LCM::Gui::Dialogs::SelectComponentsForInstallDialog->new($wizard) if ($self->_isInstall());
    $nextDialog = LCM::Gui::Dialogs::SelectComponentsForUpdateDialog->new($wizard)  if ($self->_isUpdate());
    if(defined $nextDialog){
        $wizard->AddDialog ($nextDialog);
        $self->SetNext($nextDialog);
        $wizard->SkipDialog($nextDialog->GetID()) if(!$self->_isPendingInstall() && $shouldSkipSelectComponentsDialog);
    }
}

sub _isServerAvailable  {
	my ($self) = @_;

    my $instconfig = Wx::wxTheApp()->{instconfig};
    my $mediumComponentManager = $instconfig->getComponentManager();
    my $allComponents = $mediumComponentManager->getAllComponents();
    my $serverComponent = $mediumComponentManager->getComponentByKeyName($gKeynameEngine);

    return $serverComponent;
}

sub BackInit{
    my ($self, $config) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->{instconfig};

    $instconfig->resetMsgLstContext ();
    $self->GetWizard()->unterminateChain();

    return ($self->_isActionGivenViaCommandLine()) ? {auto_back => 1} : {};
}

sub OnComboBoxUpdate {
	my ($self, $evt) = @_;
	$self->_fillSystemDescription();
}

sub OnComboBoxPendingInstall {
    my ($self, $evt) = @_;
    $self->_fillSystemDescription(1);
}

sub OnRBUpdate{
	my ($self, $evt) = @_;

	$self->_enableUpdateUi(1);
	$self->_enablePendingInstallUi(0);
    $self->_fillSystemDescription();
}

sub OnRBInstall{
	my ($self, $evt) = @_;

	$self->_enableUpdateUi(0);
	$self->_enablePendingInstallUi(0);
	$self->_hideSystemDescription();
}

sub OnRBPendingInstall{
    my ($self, $evt) = @_;

    $self->_enableUpdateUi(0);
    $self->_enablePendingInstallUi(1);
    $self->_fillSystemDescription(1);
}

sub _hideSystemDescription{
	my ($self) = @_;

	$self->{description_box}->Show(0);
	$self->{description_list}->Show(0);	
}

sub getSelectedSID {
	my ($self) = @_;

	if ($self->{_isUpdateCtrlsCreated} && $self->{rb_update}->GetValue()) {
		return $self->{'cb_installations'}->GetValue();
	} elsif ($self->{_isPendingInstallCtrlsCreated} && $self->{rb_pendingInstall}->GetValue()) {
		return $self->{'combo_pendingInstall'}->GetValue();
	} else {
		return undef;
	}
}

sub _selectUpdate{
	my($self) = @_;
    $self->{'rb_update'}->Enable(1);
    $self->{'rb_update'}->SetFocus();
    $self->{'rb_install'}->SetValue(0);
    $self->{'rb_update'}->SetValue(1);
    $self->{'combo_pendingInstall'}->Enable(0) if defined $self->{'combo_pendingInstall'};
    $self->_setSidValueToUpdateComboBox($self->{'cb_installations'});
    $self->OnRBUpdate();
}

sub _selectInstall{
    my ($self) = @_;
    $self->{'rb_install'}->SetFocus();
    $self->{'rb_install'}->SetValue(1);
    $self->{'cb_installations'}->Enable(0) if defined $self->{'cb_installations'};
    $self->{'combo_pendingInstall'}->Enable(0) if defined $self->{'combo_pendingInstall'};
}

sub _selectPendingInstall{
    my ($self) = @_;
    $self->{'rb_pendingInstall'}->SetFocus();
    $self->{'rb_pendingInstall'}->SetValue(1);
    $self->{'cb_installations'}->Enable(0) if defined $self->{'cb_installations'};
	$self->OnRBPendingInstall();
}

sub createExecutor() {
    my ($self, $configuration) = @_;

    my $processTask;
    if($configuration->getAction()  eq INSTALL_ACTION){
        require LCM::Task::GenericStackTask::InstallProcessTask;
        $processTask =  LCM::Task::GenericStackTask::InstallProcessTask->new($configuration);
    } else {
        require LCM::Task::GenericStackTask::UpdateProcessTask;
        $processTask =  LCM::Task::GenericStackTask::UpdateProcessTask->new($configuration);
    }
    $configuration->{processTask} = $processTask;
    return $processTask;
    
}

sub addInstanceNr{
    my $self = shift;
    my $collection = $self->getSystemCollection();
    my $sid = $self->getSelectedSID();
    my $instanceNr;
    if($collection->isPendingInstallation($sid)){
        $instanceNr=$collection->getPendingInstallationInstanceNr($sid);
        $self->addDescriptionStringItem("Instance Number",$instanceNr);
    } elsif($collection->isPendingLSSInstallation($sid)){
        $instanceNr=$collection->getLSSPendingInstallationInstanceNr($sid);
        $self->addDescriptionStringItem("Instance Number",$instanceNr);
    } else {
         $self->SUPER::addInstanceNr();
         return;
    }
}

sub addVersion{
    my $self = shift;
    my $sid = $self->getSelectedSID();
    my $collection = $self->getSystemCollection();
    my $versionMessage = $collection->getSystemVersion($sid);
    my @lines = split "\n", $versionMessage;

    $self->addDescriptionStringItem("Version",$lines[0]);
    if ($#lines > 0) {
        for (1 .. $#lines) {
            $self->addDescriptionStringItem("",$lines[$_]);
        }
    }
}

sub getSapSystem{
    my $self = shift;
    my $collection = $self->getSystemCollection();
    my $sid = $self->getSelectedSID();
    my $sapSystem;
    if($collection->isPendingInstallation($sid)){
        $sapSystem = $collection->getPendingInstallSystem($sid);
    } else{
        $sapSystem = $collection->getInstalledSystem($sid);
    }
}

sub addPendingInfo{
    my $self = shift;
    my $sid = $self->getSelectedSID();
    my $collection = $self->getSystemCollection();
    my $pendingInfo;
    if($collection->isPendingInstallation($sid)){
        $pendingInfo = $collection->getPendingInstallSystemInfo($sid);
    } elsif ($collection->isPendingLSSInstallation($sid)){
        $pendingInfo=$collection->getPendingLSSInstallationInfo($sid);
    } elsif ($collection->isInstalledSystemPendingUpdate($sid)) {
        $pendingInfo = $collection->getPendingUpdateInfo($sid);
    }
    return if (!defined($pendingInfo));
    my @pendingLines = split("\n", $pendingInfo);
    $self->addDescriptionStringItem("Pending action",$pendingLines[1]);
    for (my $i = 2; $i < @pendingLines; $i++) {
        $self->addDescriptionStringItem("",$pendingLines[$i]);
    }
}

sub addSystemId{
    my $self = shift;
    my $sid = $self->getSelectedSID();
    return if !defined $sid;
    $self->addDescriptionStringItem("System Id",$sid);
}

sub compileDescriptionItems{
    my ($self) = @_;
    my $collection = $self->getSystemCollection();
    if($collection->isPendingLSSInstallation($self->getSelectedSID())){
        $self->addPendingLSSInfo();
    }
    else{
        $self->SUPER::compileDescriptionItems();
    }
}

sub addPendingLSSInfo {
    my ($self) = @_;
    
    $self->addSystemId();
    $self->addInstanceNr();
    my $collection = $self->getSystemCollection();
    my $installationPath = $collection->getPendingLSSInstallationTarget($self->getSelectedSID()) // '<unknown>';
    $self->addDescriptionStringItem("Installation Path",$installationPath);
    $self->addPendingInfo();
}

sub getSystemCollection{
    my $self = shift;
    my $app = Wx::wxTheApp;
    my $actionConfig = $app->getActionConfiguration();
    return $actionConfig->getSystemCollection();
}

1;
