package LCM::Gui::Dialogs::SelectComponentSourceResidentDialog;

use strict;
use base qw (LCM::Gui::Dialogs::SelectComponentSourceDialog);

sub init {
	my $self = shift;

	my $instconfig = $self->_getInstconfig();
	$instconfig->{params}->{SelectedComponents}->{set_interactive} = 0;
	$instconfig->setBatchValueOfRequiredParams('VerifySignature');
	$self->SUPER::init();
	return {};
}

sub _getInstconfig() { return Wx::wxTheApp->{instconfig}; }

sub Reset {}

sub fillDefaultComponentLocations {
	my($self) = @_;
	$self->getComponentManager()->printDetectedComponents() if($self->getComponentManager()->hasComponents());
}

sub hasSelectedComponents {
	my ($self) = @_;
	my @allComponents = ( @{ $self->getComponentManager()->getAllComponents() } );
	my @listedComponents = values(%{$self->{_componentDirsCsv}});
	return scalar(@listedComponents) || scalar(@allComponents);
}

1;