package LCM::Gui::Dialogs::Uninstall::KeepCockpitTenantDialog;

use strict;
use warnings;
use Wx qw (
        wxEXPAND
        wxTOP
        wxHORIZONTAL
        wxBOTTOM
        wxLEFT
        wxALL
        );

use parent 'SDB::Install::Gui::Dialogs::GenericParameter';

sub new {
    my ( $self ) = shift->SUPER::new( @_ );
    $self->{id}         = 'KeepCockpitTenantDialog';
    $self->{label_text} = "Specify Cockpit Properties";
    $self->{name}       = "Define Cockpit Properties";
    return $self;
}

sub getParamKeys {
    my ( $self ) = @_;
    return ['CockpitXSSpace', 'CockpitTenant', 'KeepCockpitTenant'];
}

sub init {
	my ($self) = @_;
	my $app = Wx::wxTheApp();
	my $instconfig = $app->getInstconfig();
	$instconfig->setInteractive($_, 1) for @{$self->getParamKeys()};

	my $rc = $self->SUPER::init();

	for ('CockpitXSSpace', 'CockpitTenant') {
		my $control = $self->getParamCtrl($_);
        my $default = $instconfig->getDefault($_);
        my $batchValue = $instconfig->getBatchValue($_);
		$control->Disable() if($control && $default && !$batchValue);
	}

	return $rc;
}

sub DirectNavigationAllowed {
	return 0;
}

1;