#!/usr/bin/perl

package LCM::Gui::Dialogs::Uninstall::OSLevelCredentialsDialog;

use SDB::Install::Gui::Dialogs::GenericParameter;

use Wx qw (wxEXPAND wxTE_PASSWORD wxALIGN_CENTER_VERTICAL wxOK wxCENTRE wxICON_EXCLAMATION wxLEFT wxRIGHT);
use strict;

our @ISA = qw (SDB::Install::Gui::Dialogs::GenericParameter);


sub new{
    my($self ) = shift->SUPER::new(@_);
    $self->{id} = 'OSLevelCredentials';
    $self->{label_text} = "Provide OS Level Credentials";
    $self->{name} = 'Enter OS Level Credentials';
    return $self;
}

sub init {
    my ($self, $config) = @_;
    my $result = $self->SUPER::init($config);
    
    my $rootUserLabel = $self->{dynctrl}->{RootUser_label};    
    if ($result && $rootUserLabel) {
        $rootUserLabel->SetRequired(1);
    }
    return $result;    
}

sub _addRootPasswordControl {
	my ($self, $instconfig) = @_;

	my $rootPasswordParam = $instconfig->{params}->{'RootPassword'};
	my $rootPasswordLabel = SDB::Install::Gui::Control::Label->new($self, -1, $rootPasswordParam->{str}, 0);
	$rootPasswordLabel->SetToolTip ( $rootPasswordParam->{desc} );
    $self->{_uiControls}->{'RootPasswordLabel'} = $rootPasswordLabel;

	my $rootPasswordControl = new Wx::TextCtrl ($self, -1, '',[-1,-1], [-1,-1],wxTE_PASSWORD);
	$rootPasswordControl->SetToolTip ($rootPasswordParam->{desc});
	$self->{_uiControls}->{'RootPassword_ctrl'} = $rootPasswordControl;

	$self->{'grid_sizer'}->Add($rootPasswordLabel, 0, wxALIGN_CENTER_VERTICAL);
	$self->{'grid_sizer'}->Add($rootPasswordControl, 1, wxEXPAND );
}

#Override
sub AddAdditionalParams {
	my ($self, $instconfig) = @_;
	if(!$instconfig->isSkipped('RootUser')) {
		$self->_addRootPasswordControl ($instconfig);
	}
	return 1;
}

sub getParamKeys{
    my ($self, $instconfig) = @_;
    my $paramKeys = ['HostagentPassword', 'Password', 'RootUser'];
    return $paramKeys;
}

sub Reset{
    my ($self) = @_;
    
    if(defined $self->GetSizer()){
        $self->GetSizer->Clear (1);
    }
    delete($self->{_uiControls});
    $self->SUPER::Reset();
}

sub Destroy{
    my ($self) = @_;
    $self->Reset();
    $self->SUPER::Destroy;
}

sub Process{
    my ($self,$config) = @_;
    my $rc = $self->SUPER::Process ($config);
	my $instconfig = Wx::wxTheApp->{instconfig};
    if($rc && !$instconfig->isSkipped('RootUser') && !$instconfig->isSkipped('RootPassword')){
    	my $passwordControl = $self->{_uiControls}->{'RootPassword_ctrl'};
    	if (!$instconfig->setValue ('RootPassword', $passwordControl->GetValue())){
    		my $rootPasswordString = $instconfig->{params}->{RootPassword}->{str};
			Wx::MessageBox( "Checking $rootPasswordString failed.\n" . $instconfig->GetErrorString (), "Configuration Error", wxOK | wxCENTRE | wxICON_EXCLAMATION, $self);
			$passwordControl->SetFocus();
			return undef;
		}
    }
    return $rc;
}

1;