package  LCM::Gui::Dialogs::UpgradeParameterDialog;

use strict;
use LCM::Gui::DialogUtilities;
use Wx qw ( wxCENTRE wxICON_EXCLAMATION wxOK wxTE_PASSWORD wxALIGN_CENTER_VERTICAL wxEXPAND );
use experimental qw (smartmatch);

use base 'SDB::Install::Gui::Dialogs::UpgradeParameter';

sub getParamKeys{
    my $self = shift @_;
    my @skippedParams = ("CertificatesHostmap", "StreamingClusterManagerPassword", "BasepathStreaming", 
                         "EsDataPath", "EsLogPath", "Ignore", "AcceleratorUser", "AcceleratorPassword", "AddRoles", "AddHosts",
                         'AcceleratorDataPath', 'AcceleratorLogPath', 'ListenInterface', 'InternalNetwork',
                         'AutoAddXS2Roles', 'SelectedXs2Applications', 'XsEaDataPath',
                         'OrgManagerUser', 'OrgManagerPassword', 'OrgName', 'ProdSpaceName', 'ContinueUpdate', 'XSSpaceIsolation',
                         'XSSpaceUserIdSAP', 'XSSpaceUserIdProd', 'RoutingMode', 'XsDomainName', 'XSComponentsNoStart',
                         'CockpitXSSpace','SelectedComponents', 'InstallXSInDefaultTenant', 'XSTenantDatabaseName');
    my ($instconfig) = @_;
    my $paramKeys = $self->SUPER::getParamKeys(@_);
    push(@skippedParams, @{$instconfig->getLSSParams()});

    my $componentManager = $instconfig->getComponentManager();
    if ( $instconfig->isScopeInstance()) {
        push (@skippedParams, 'RootUser');
        push (@skippedParams, 'RootPassword');
        $self->_skipRootParams();
    }

# If hosts are added, sapadm credentials are handled on the previous page
    my $isAddingHosts = ( ! $instconfig->isSkipped('AddHosts')  && defined $instconfig->getValue('AddHosts') );
    if($isAddingHosts){
        if ($instconfig->isUseSAPHostagent()) {
            push (@skippedParams, 'HostagentPassword');
        } else {
            push (@skippedParams, ('RootUser', 'RootPassword'));
        }
    }

    if( defined $instconfig->getValue('ReferenceDataPath') ) {
        push (@skippedParams, ('ReferenceDataPath'));
    }

    if ($instconfig->useNonDefaultTenantForXSA()) {
# This if prevents back-next issues when the Tenant credentials appear on two different dialogs
        push (@skippedParams, 'TenantUser');            # The dedicated dialog for XSA tenant credentials will be used
        push (@skippedParams, 'SQLTenantUserPassword'); # The dedicated dialog for XSA tenant credentials will be used
    }
    
    my @filteredKeys = grep { not ($_ ~~ @skippedParams) } @$paramKeys;
    return \@filteredKeys;
}

sub init{
    my ($self, @args) = @_;
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig;

# If hosts are added, root credentials are handled on the previous page
    my $isAddingHosts = (! $instconfig->isSkipped('AddHosts')) && defined($instconfig->getValue('AddHosts'));
    if (!$instconfig->isSkipped ('RootUser') && ! $isAddingHosts){
        $instconfig->setSkip ('RootPassword', 0);
        $instconfig->{params}->{RootPassword}->{mandatory} = 0;
    }
    my $initializationState = $self->SUPER::init(@_);
    return $initializationState;
}

sub _validateConfirmableField {
    my ($self, $parameterId) = @_;
    my $configuration = GetAppConfig();
    my $passwordControl = $self->{dynctrl}->{$parameterId . '_ctrl'};
    my $passwordControlConfirmation = $self->{dynctrl}->{$parameterId . '_ctrl_confirmation'};
    return {} if (!defined $passwordControl || !defined $passwordControlConfirmation);

    my $value = $configuration->getValueFromUIString ($parameterId, $passwordControl->GetValue ());
    my $confirmationValue = $configuration->getValueFromUIString ($parameterId, $passwordControlConfirmation->GetValue ());

    if( ! defined $confirmationValue || $confirmationValue eq '' ) {
        Wx::MessageBox("Checking " . $configuration->getString($parameterId) . " failed.\nConfirmation value is empty", "Configuration Error", wxOK|wxCENTRE|wxICON_EXCLAMATION, $self);
        $passwordControlConfirmation->SetFocus();
        return undef;
    }
    if ( $value ne $confirmationValue ) {
        Wx::MessageBox("Checking " . $configuration->getString($parameterId) . " failed.\nPasswords do not match", "Configuration Error", wxOK|wxCENTRE|wxICON_EXCLAMATION, $self);
        $passwordControl->SetFocus();
        return undef;
    }
    return {};
}

sub _skipRootParams {
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig;
    $instconfig->setSkip ('RootUser', 1);
    $instconfig->setSkip ('RootPassword', 1);
}

sub shouldCheckUpdate {
    my $self = shift;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->{instconfig};
    return $instconfig->isSkipped('Password') ? 0 : 1;
}

sub Process{
    my ($self, @args) = @_;
    my $rc = $self->SUPER::Process (@args);
    $rc = $rc && $self->_validateConfirmableField('SystemDBSQLPassword');

    $self->GetWizard()->RefreshSkippableDialogs();

    return $rc;
}

1;
