package LCM::HDBComponentsConfigurator;

use strict;
use parent 'Exporter';
use File::Spec;
use SDB::Install::System qw (isAdmin);
use SDB::Install::ClientRegisterTools;

#----------------------------------------------------------------------------
#
# Actions that can be executed on HDB components.
#
our $action_register   = 'action_register';
our $action_unregister = 'action_unregister';

our @EXPORT_OK = qw($action_register $action_unregister);

sub new {
	my ($class, $logger) = @_;
	my $self = {
		_logger => $logger,
	};
	return bless($self, $class);
}

sub configureLocalHdbComponents {
	my ($self, $componentNames, $action, $sharedDir, $sid) = @_;
	my $logger = $self->{_logger};
	my $doUnregister = ($action eq $action_unregister);

	if(! isAdmin()) {
		my $actionString = ($action =~ /unregister/) ? 'unregistration' : 'registration';
		$logger->getErrMsgLst()->AddError("Component $actionString is possible with root privileges only");
		return undef;
	}

	foreach my $component ( @{$componentNames} ) {
		my $componentPath = File::Spec->catdir($sharedDir, $sid, $component);
		my $rc = $self->_handleLocalComponent($componentPath, $doUnregister);

		return undef if(!$rc);
	}
	return 1;
}

sub _handleLocalComponent {
	my ($self, $path, $doUnregister) = @_;
	my $msglst = $self->{_logger}->getMsgLst();
	my $errlst = $self->{_logger}->getErrMsgLst();

	return $doUnregister ? $self->_unregisterComponent($path, $msglst, $errlst) : $self->_registerComponent($path, $msglst, $errlst);
}

sub _registerComponent {
	my ($self, $path, $msglst, $errlst) = @_;
	my $returnCode = registerClient($path, $msglst, $errlst);

	if($returnCode){
		$msglst->AddMessage("Installation '$path' successfully registered");
	} else {
		$errlst->AddMessage("Registration of installation '$path' failed");
	}
	return $returnCode;
}

sub _unregisterComponent {
	my ($self, $path, $msglst, $errlst) = @_;
	my $returnCode = unregisterClient($path, $msglst, $errlst);

	if($returnCode){
		$msglst->AddMessage("Installation '$path' successfully unregistered");
	} else {
		$errlst->AddMessage("Unegistration of installation '$path' failed");
	}
	return $returnCode;
}

1;
