#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: HDB Installer

package LCM::Installer;

use SDB::Install::System qw (isSidadmin);
use SDB::Install::SysVars qw ( $path_separator $re_path_separator $isWin );
use LCM::ComponentManager::SystemComponentManager;
use LCM::Manifests::ResidentInstallerManifest;
use SDB::Install::Installer;
use SDB::Install::SAPSystem;

use strict;
our @ISA = qw (SDB::Install::Installer Exporter);

our $installedPattern = join ($re_path_separator, '([A-Z][A-Z0-9][A-Z0-9])','hdblcm', 'instruntime');
our @EXPORT_OK = qw($installedPattern);

sub new{
    my ($self, $sysInfo, $instconfig) = @_;
    $self = $self->SUPER::new(@_);
    $self->{sysInfo} = $sysInfo;
    $self->{instconfig} = $instconfig;
    return $self;
}

sub getRuntimeDir {
	return $_[0]->{runtimedir};
}

sub isInstalled() {
	my $envVar = $ENV{'HDB_INSTALLER_IS_INSTALLED'};
	if (defined $envVar){
		if (SDB::Install::SAPSystem::matchesPatternSID (undef, $envVar)){
			$_[0]->{_sid} = $envVar;
			return 1;
		}
		return $envVar == 1;
	}

	if (!defined $_[0]->{runtimedir}){
		return undef;
	}

	if ($isWin){
		return $_[0]->{runtimedir} =~ /$installedPattern/i;
	}
	else{
		return $_[0]->{runtimedir} =~ /$installedPattern/;
	}
}

sub getOwnSystemComponentManager () {
	my ($self, $sapmnt) = @_;

	if (!$self->isInstalled){
		return undef;
	}

	my $sid = $self->getSid();
	my $scm = new LCM::ComponentManager::SystemComponentManager ($self->{instconfig});
	$scm->setMsgLstContext([$self->getMsgLst()]);

	if(isSidadmin($sid)){
		$scm->setSidAdmUserExecution(1);
	}
	if ($scm->detectComponentsBySid ($sid)){
		return $scm;
	}

	if ((defined $sapmnt) and ($scm->detectComponentsBySapmntSid ($sapmnt, $sid))){
		return $scm;
	}

	return undef;
}

sub getSid{
	my ($self) = @_;
	if (defined $self->{_sid}){
		return $self->{_sid};
	}

	my $runtimeDir = $self->getRuntimeDir();
	my $pattern = $self->getServerHdblcmSapmntSidPattern();
	my ($hanamnt, $sid) = ($runtimeDir =~ /$pattern/i);
	
	if( !defined $sid){
		$pattern = $self->getServerSapmntSidPattern();
		($hanamnt, $sid) = ($runtimeDir =~ /$pattern/i);
	}

	$self->{_sid} = $sid;
	return $sid;
}

sub getOwnSapSystem{
	my ($self) = @_;

	my $sid = $self->getSid ();
	my $systems = SDB::Install::SAPSystem::CollectSAPSystems ();
	my $ownSapSystem = $systems->{$sid} if defined $systems;

   	if (defined $ownSapSystem){
   		return $ownSapSystem;
	}

	return undef;
}

sub GetVersion {
	my ($self) = @_;
	my $manifest = $self->getManifest();
	return undef if(!defined($manifest));
	return $manifest->getVersion();
}

sub getManifest {
	my ($self) = @_;
	my $installerDir = $self->getRuntimeDir();
	return undef if(!defined($installerDir));

	my $manifestPath = File::Spec->catfile($installerDir, 'manifest');
	return LCM::Manifests::ResidentInstallerManifest->new($manifestPath);
}

sub getKit {
	my ($self) = @_;

	my $installerDir = $self->{runtimedir};
	if (!defined $installerDir) {
		return undef;
	}

	$installerDir =~ s/[\\\/]+instruntime[\\\/]*$//;

	my $kitDir = $installerDir;
	my $serverKitDir = File::Spec->catfile($kitDir, 'server');

	if (-d $serverKitDir) {
		$kitDir = $serverKitDir;
	}

	my $kit = new SDB::Install::Kit ($kitDir, $self->{sysInfo});

	return $kit;
}

sub getFullVersion {
	my ($self) = @_;
	my $manifest = $self->getManifest();
	return undef if(!defined($manifest));
	return $manifest->getBuildstring();
}

1;
