package LCM::Landscape::ProductFactory;

use strict;
use LCM::Landscape::PDXml;

sub new {
	my ($class, $componentManager, $listOfComponnentDirs, $context) = @_;
	my $self = bless({}, $class);

	$self->_detectProdcuts($componentManager, $listOfComponnentDirs, $context);

	return $self;
}

sub getProducts {
	my ($self) = @_;
	return $self->{products};
}

sub _setProducts {
	my ($self, $products) = @_;
	$self->{products} = $products;
}

sub _detectProdcuts {
	my ($self, $componentManager, $listOfComponnentDirs, $context) = @_;
	my $products = {};

	for my $dir (@{$listOfComponnentDirs}) {
		_addMessage($context, "Processing PD.XML in directory '$dir'...");

		my $pdXml = new LCM::Landscape::PDXml($componentManager, $dir, $context);
		my $product = $pdXml->getProduct();
		my $productName = $product->getName();
		my $productId = $product->getID();
		my $productVersion = $product->getVersion();
		my $productInstances = $product->getProductInstances() || [];
		my $productFoundMessage = $product->isEmpty() ? "Found empty product '$productName $productVersion'. Skipping..." : "Found product '$productName $productVersion'.";

		_addMessage($context, $productFoundMessage);
		for my $productInstance (@{$productInstances}){
			my $productInstanceName = $productInstance->getName();
			my $productInstanceFoundMessage = $productInstance->isEmpty() ? "Found empty product instance '$productInstanceName'. Skipping..." : "Found product instance '$productInstanceName'.";
			_addMessage($context, $productInstanceFoundMessage);
		}

		if(exists($products->{$productId})){
			$products->{$productId}->addProductInstances($productInstances);
		} elsif(!$product->isEmpty()) {
			$products->{$productId} = $product;
		}
	}
	$self->_setProducts([ values(%{$products}) ]);
}

sub _addMessage {
	my ($context, $message) = @_;
	$context->getMsgLst()->addMessage($message) if($context);
}

1;