package LCM::Persistence::XMLDetector;

use strict;
use File::Spec;
use LCM::FileUtils;
use LCM::Persistence::XML;
use SDB::Install::SAPSystem qw(CollectSAPSystems);
use SDB::Install::Globals qw($gSAPLocation);

sub detect {
	my ($sid, $msgLst) = @_;

	if (!defined $msgLst) {
		$msgLst = new SDB::Install::MsgLst();
	}
	my $filePathList = _getCandidatePathList($sid, $msgLst);
	if (! defined $filePathList){
	    my $fileList = listDirectory($gSAPLocation, $msgLst);
	    @{$filePathList} = grep {/\Q$sid\E\.pending_(\w+)\.xml$/ } @{$fileList};
	    @{$filePathList} = map { File::Spec->catfile($gSAPLocation, $_) } @{$filePathList};
	}
	my %resultSet = ();

	return \%resultSet if(!defined($filePathList));

	for my $candidateFilePath (@{$filePathList}) {
		next if(!-f $candidateFilePath || $candidateFilePath !~ /pending_(\w+)\.xml$/);

		my $componentKey = $1;
		my $persistenceXMLObject = new LCM::Persistence::XML($candidateFilePath);

		if ($persistenceXMLObject->errorState()) {
			$msgLst->addWarning($persistenceXMLObject->getErrorString());
		}

		if ($persistenceXMLObject->existsMandatoryValidationError()){
			$persistenceXMLObject = undef;
		}

		$resultSet{$componentKey} = $persistenceXMLObject;
	}
	return \%resultSet;
}

sub _getCandidatePathList {
	my ($sid, $msgLst) = @_;
	my $sapSystem = _getSAPSystemObject($sid, $msgLst);

	return undef if(!defined($sapSystem));

	my $globalSidDirectory = $sapSystem->get_globalSidDir() || $sapSystem->getUsrSapSid(); # Handle the case where /<sapmnt>/<SID> is /usr/sap/<SID>
	my $fileList = listDirectory($globalSidDirectory, $msgLst);

	return defined($fileList) ? [ map { File::Spec->catfile($globalSidDirectory, $_) } @{$fileList} ] : undef;
}

sub _getSAPSystemObject {
	my ($sid, $msgLst) = @_;
	my $allSystems = CollectSAPSystems();
	my $sapSystem = $allSystems->{$sid};

	if(!defined($sapSystem)){
		$msgLst->addError("No SAP system '$sid' found");
	}
	return $sapSystem;
}

1;