package LCM::PostExecuteAction::UnregisterComponents;

use strict;
use LCM::Component::Registrable qw($RETURN_CODE_SUCCESS $RETURN_CODE_ERROR);
use LCM::HDBComponentsConfigurator qw($action_register $action_unregister);
use base qw(LCM::PostExecuteAction);

my $STATUS_OK        = 1;
my $STATUS_ERROR     = 0;

sub new {
	my (
		$class,              $logHandler,
		$instconfig,         $shouldFailOnError,
		$sharedDir,          $sid,
		$skipComponentsByBatchKeyList
	) = @_;
	my $self = {};

	bless $self, $class;

	$self->{_shouldFailOnError}  = $shouldFailOnError;
	$self->{_logHandler}         = $logHandler;
	$self->{_instconfig}         = $instconfig;
	$self->{_sharedDir}          = $sharedDir;
	$self->{_sid}                = $sid;
	$self->{_skippedComponents}  = $skipComponentsByBatchKeyList;
	return $self;
}

sub execute {
	my ($self)           = @_;
	my $config           = $self->{_instconfig};
	my $componentManager = $config->getComponentManager();
	my $logHandler       = $self->{_logHandler};
	my $saveContext = $logHandler->getMsgLstContext();
	my $skipComponentsByKeyname = [];

	if ( defined $self->{_skippedComponents} ) {

		foreach my $skippedComponent ( @{ $self->{_skippedComponents} } ) {
			my $component = $componentManager->getComponentByBatchKey($skippedComponent);
			if ( defined $component ) {
				push( @$skipComponentsByKeyname, $component->getComponentKeyName() );
			}
		}
	}
	my $rc = $self->unregisterComponents(
		$logHandler,                  $config,
		$self->{_sharedDir},          $self->{_sid},
		$skipComponentsByKeyname,
		$componentManager
	);
    $logHandler->setMsgLstContext($saveContext);
	if ( $rc == $RETURN_CODE_SUCCESS ) {
		return $STATUS_OK;
	}
	else {
		return $STATUS_ERROR;
	}
}

sub shouldFailOnError {
	return $_[0]->{_shouldFailOnError};
}

sub isStatusOK {
	my ( $self, $status ) = @_;
	return $status == $STATUS_OK;
}

sub unregisterComponents {
	my $rc = $RETURN_CODE_SUCCESS;
	my (
		$self,          $logger,             $instconfig,
		$sharedDir,     $sid,                $skipComponentsByKeynameList,
		$componentManager
	) = @_;
	my $components = $componentManager->getAllComponents() ;
		foreach my $registrable ( @{$components} )
		{
			if ($self->_isComponentSkipped($registrable, $skipComponentsByKeynameList))
			{
				$logger->getMsgLst()->addMessage("Skipping unregistration of ".$registrable->getComponentName()."...");
                next;
			}
			$registrable->resetMsgLstContext();
            $registrable->setMsgLstContext($logger->getMsgLstContext());
            $registrable->setProgressHandler($logger->getMsgLst()->getProgressHandler());
			my $current_rc =
			  $registrable->unregister( $logger, $instconfig, $sharedDir,
				$sid );
			if ( $current_rc == $RETURN_CODE_ERROR ) {
				$rc = $RETURN_CODE_ERROR;
			}
		}
	return $rc;
}

sub _isComponentSkipped {
	my ( $self, $component, $skipComponentsByKeynameList ) = @_;
	if ( !defined $skipComponentsByKeynameList ) {
		return 0;
	}
	my %skipComponentsByKeynameMap = map { $_ => 1 } @{$skipComponentsByKeynameList};
	my $skip = exists( $skipComponentsByKeynameMap{ $component->getComponentKeyName() } );
	return $skip;
}

1;
