package LCM::Python::HanaPropertiesHelper;

use base qw(LCM::Python::PythonExecutor);
use LCM::Installer;
use strict;

my $SET_OF_GLOBAL_PROPERTY_FAILED = 'Set of global property failed';
my $GET_OF_GLOBAL_PROPERTY_FAILED = 'Get of global property failed';
my $SET_GLOBAL_PROPERTY = 'setGlobalProperty';
my $GET_GLOBAL_PROPERTY = 'getGlobalProperty';

my $HDB_PROPERTIES_SCRIPT = <<EOF;
import ConfigMgrPy
import sys

def getGlobalProperty(file,propSection,property):
\tprint 'getting global property "{0}" in file "{1}"'.format(property, file)
\tcfg=ConfigMgrPy.LayeredConfiguration(file, ConfigMgrPy.CUSTOMER)
\tresult=cfg.getStringValue(propSection, property)
\treturn result
\t
def setGlobalProperty(file,propSection,property,value):
\tprint 'setting global property "{0}" in file "{1}"'.format(property, file)
\tcfg=ConfigMgrPy.LayeredConfiguration(file, ConfigMgrPy.CUSTOMER)
\tretCode=cfg.setStringValue(propSection, property, value)
\treturn 'python script finished with code "{0}"'.format(retCode)
\t

if __name__=="__main__":
\tif sys.argv[1] == "getGlobalProperty":
\t\tprint(getGlobalProperty(*sys.argv[2:]))
\telif sys.argv[1] == "setGlobalProperty":
\t\tprint(setGlobalProperty(*sys.argv[2:]))
EOF

sub setGlobalProperty {
	my ($self, $file, $section, $propperty, $value, $uid, $gid) = @_;
	my $args = [$SET_GLOBAL_PROPERTY, $file, $section, $propperty, $value];
	return $self->_executePythonCommand($HDB_PROPERTIES_SCRIPT, $SET_OF_GLOBAL_PROPERTY_FAILED, $args, $uid, $gid);
}

sub getGlobalProperty {
	my ($self, $file, $section, $propperty, $uid, $gid) = @_;
	my $args = [$GET_GLOBAL_PROPERTY, $file, $section, $propperty];
	my ($responseCode, $executor) =  $self->_executePythonCommand($HDB_PROPERTIES_SCRIPT, $GET_OF_GLOBAL_PROPERTY_FAILED, $args, $uid, $gid);
	if(defined($responseCode) && defined($executor)) {
		return $executor->getOutputLines()->[1];
	}
	return undef;
}

1;