#!perl 
#===============================================================================
#
# Copyright (C) 2000 - 2014 by SAP AG,  http://www.sap.com.
# All rights reserved.
#
# This software is the confidential and proprietary information of SAP AG.
# You shall not disclose such confidential information and shall use it only
# in accordance with the terms of the license agreement you entered into with SAP.
#
#       AUTHOR: i072928
#

=head1 NAME

Installer

=head1 DESCRIPTION

Extends LCM installer and alters some of it's properties to be suitable for the
hdblcm runtime.
=cut

#===============================================================================
package LCM::ResidentInstaller;

use strict;
use LCM::Installer qw($installedPattern);
use SDB::Install::SysVars qw ($path_separator $isWin);

#Override
sub getServerUsrSapSidPattern {
    
	my $server_usr_sap_sid_pattern = join(
		$SDB::Install::Installer::pattern_multiple_path_separators,
		$SDB::Install::Installer::usr_sap_pattern,
		'(' . $SDB::Install::Installer::sid_pattern . ')'
	);
	
	return $server_usr_sap_sid_pattern;
}

#Override
sub getServerSapmntSidPattern {

	my $server_sapmnt_sid_pattern =
		$isWin
		? join(
		$SDB::Install::Installer::pattern_multiple_path_separators,
		'(' . $SDB::Install::Installer::unc_pattern . ')?',
		'(' . $SDB::Install::Installer::sid_pattern . ')',
		'hdblcm',
		'instruntime'
		)
		: join(
		$SDB::Install::Installer::pattern_multiple_path_separators,
		'^(.*)', '(' . $SDB::Install::Installer::sid_pattern . ')',
		'hdblcm', 'instruntime'
		);

	return $server_sapmnt_sid_pattern;
}
our @ISA       = qw (LCM::Installer);
our @EXPORT_OK = qw($installedPattern);

#Override
sub getInstallation {
	my ( $self, $msgLst ) = @_;
	return $self->SUPER::getInstallation ( $msgLst, 1 );
}

#Override
sub isInstalled() {
	return 1;
}

#Override
sub isServerInstaller() {
	return 1;
}

1;
