package LCM::SHA::OperationsDeployer;

use strict;
use base qw(SDB::Install::BaseLegacy);
use LCM::App::ApplicationContext;
use SDB::Install::SysVars qw ($isWin);

sub new {
	my $class = shift();
	return bless({}, $class);
}

sub deployConfigurations {
	my ($self, $hostlist, $deploymentStrategy, $isNotVerbose, $isUseCache, $isLocal) = @_;
	
	if($isWin){
		$self->AddWarning("Deployment of SAP Host Agent configurations is not supported on Windows.");
        return 1;
	}
	my $filteredHostlist = $self->_filterHostlist($hostlist, $isUseCache);
	my $returnCode = 0;
	
	if(scalar(@{$filteredHostlist})){
		my $informationMessage = "Deploying SAP Host Agent configurations...";
		my $mainMessage = ($isNotVerbose) ? $self->AddMessage($informationMessage) : $self->AddProgressMessage($informationMessage);
		my $saveContext = $self->setMsgLstContext([$mainMessage->getSubMsgLst()]);
	
		$returnCode = $self->_deployOnHosts($filteredHostlist, $deploymentStrategy, $isLocal);

		$mainMessage->endMessage();
		$self->setMsgLstContext($saveContext);
	}
	
	return (!defined($returnCode) || $returnCode) ? undef : 0;
}

sub _deployOnHosts {
    my ($self, $hostlist, $deploymentStrategy, $isLocal) = @_;
    
    return 1 if (!defined $hostlist); # Invalid argument, we should always fail in such case

	$deploymentStrategy->setMsgLstContext([$self->getMsgLst()]);
	return 1 if (!$deploymentStrategy->initialize()); # Failed to complete initialization
    
    my $rc = 0;
    for my $currentHost (@{$hostlist}) {
		my $result = $deploymentStrategy->deploy($currentHost, $isLocal);
		$self->_notifyCache($currentHost, $result);
		$rc = 1 if(!$result);
    }
	$deploymentStrategy->cleanup();
    return $rc;
}

sub _notifyCache {
	my ($self, $host, $isSuccess) = @_;
	if($isSuccess){
		require LCM::SHA::DeploymentCache;
		my $deploymentCache = LCM::SHA::DeploymentCache::getInstance();
		$deploymentCache->setDeployedOnHost($host);
	}
}

sub _filterHostlist {
	my ($self, $hostlist, $isCached) = @_;
	
	return $hostlist unless($isCached);
	
	require LCM::SHA::DeploymentCache;
	my $deploymentCache = LCM::SHA::DeploymentCache::getInstance();
	
	return [ grep { ! $deploymentCache->isDeployedOnHost($_) } @{$hostlist} ];
}

1;
