package LCM::Slpp::ParameterAdapter::MultipleSelectionParameter;

use strict;
use base qw(LCM::Slpp::ParameterAdapter::SelectionParameter);

sub getInternalSelectedValues {
	my ($self) = @_;
	return $self->_getInternalValues('value')
}

sub getInternalDefaultValues {
	my ($self) = @_;
	return $self->_getInternalValues('default')
}

sub getInternalBatchValues {
	my ($self) = @_;
	return $self->_getInternalValues('batchValue');
}

sub _getInternalValues {
	my ($self, $valueId) = @_;

	my $value = $self->{hdblcmRepresentation}->{$valueId};
	my @csvTokens = split(/\s*,\s*/,$value);

	return \@csvTokens;
}

sub parseInternalValue {
	my ($self, $slppRepresentation, $isBatchValue) = @_;
	
	my $selectedValues = $self->_parseSelectedValues($slppRepresentation, $isBatchValue);
	
	my $value = join(',', @{$selectedValues});
	return $value;
}

sub hasDefaultTable {
	my ($self) = @_;
	return $self->_isSet() ? 0 : 1;
}

1;