package LCM::Slpp::ParameterAdapter::TableParameter;

use strict;
use base qw(LCM::Slpp::ParameterAdapter);

sub new {
    my $class = shift();
    my $self = $class->SUPER::new(@_);
    $self->{tuplesInfo} = {
        nextTupleId => 1,
        keyToId => {},
    };
    
    return $self;
}

sub getSlppValueTag {
	return 'tablevalue';
}

sub getSlppBatchValueTag {
    return 'batchtablevalue';
}

sub hasStructure {
	return 1;
}

sub _getTupleIdByKey {
    my ($self, $key) = @_;
    my $keyToIdHash = $self->{tuplesInfo}->{keyToId};
    
    if (!exists($keyToIdHash->{$key})) {
        $keyToIdHash->{$key} = $self->_getNextTupleId();
    }
    return $keyToIdHash->{$key};
}

sub _getNextTupleId {
    my ($self) = @_;
    return $self->{tuplesInfo}->{nextTupleId}++;
}

1;