package LCM::Slpp::SlppSubtaskListener;

use strict;
use parent 'LCM::Task::BaseTaskListener';

sub new{
	my ($class, $task, $scenarioExecutor) = @_;
	my $self = $class->SUPER::new();
	$self->_setScenarioExecutor($scenarioExecutor);
	$self->notifyTaskChanged($task);
	return $self;
}

sub notifyTaskChanged{
	my ($self, $task) = @_;
	my $scenarioExecutor = $self->_getScenarioExecutor();
	my $taskInformation = $self->_createExecutionTaskInformation($task);
	my $taskId = $task->getId();

	$scenarioExecutor->sendTaskInfo($taskId, $taskInformation);
}

sub _getScenarioExecutor {
	my ($self) = @_;
	return $self->{scenarioExecutor};
}

sub _setScenarioExecutor {
	my ($self, $scenarioExecutor) = @_;
	$self->{scenarioExecutor} = $scenarioExecutor;
}

sub _createExecutionTaskInformation{
	my ($self, $task) = @_;
	my $taskInformation = {};
	my $warningsArray = [ @{$task->getWarningMessages()} ];
	my $name = $task->getName();
	my $taskId = $task->getId();
	if($task->getStatus()->isInRunningState()){
		$name = $task->getExecutionName();
	}

	$taskInformation->{id} = $taskId;
	$taskInformation->{name} = $name;
	$taskInformation->{description} = $task->getDescription();
	$taskInformation->{state} = $task->getStatus()->getState();
	$taskInformation->{type} = $task->getType();
	$taskInformation->{startedAt} = $task->getStartedAt() // '';
	$taskInformation->{finishedAt} = $task->getFinishedAt() // '';
	$taskInformation->{resourcesLogFilename} = $task->getSlppLogFileName();
	$self->_setLogLocation($task, $taskInformation);
	$taskInformation->{progress} = $task->getProgress();
	$taskInformation->{warnings} = $warningsArray;

	return $taskInformation;
}

sub _setLogLocation{
	my ($self, $task, $taskInformation) = @_;
	my $logLocation = $task->getLogLocation();
	$logLocation =~ s/msg$/log/g;
	$taskInformation->{logLocation} = $logLocation;
}

1;