package LCM::Slpp::TimeoutOptionAdapter;

use strict;
use base qw(LCM::Slpp::ParameterAdapter::MapParameter);

sub new{
    my ($class, $paramId, $hdblcmRepresentation, $config) = @_;	
    my $self = $class->SUPER::new($paramId, $hdblcmRepresentation);
    $self->{config} = $config;
    bless($self,$class);
    return $self;
}

sub setTimeouts {
    my ($self, $key, $value) = @_;
    my $config = $self->{config};

    if( ! defined $value && ! $config->{params}->{Timeouts}->{value}->{$key} ) {
        return 1;
    }

    my $optionTimeout = $config->getOptionTimeout();
    if (!defined $optionTimeout) {
    	return 0;
    }

    my $context = $optionTimeout->getOptionName();
    if (!$self->isKeyValid( $key, $optionTimeout)) {
        $self->{config}->appendErrorMessage("Parsing '$context' failed: Unknown argument '$key'");
    	return undef;
    }

    if (!$self->isValueValid($value)) {
        $self->{config}->appendErrorMessage("Parsing '$context' failed: Value of argument '$key' has to be a positive integer");
        return undef;
    }

    if (!defined $value) {
        $self->_resetValue($key);
    } else {
        $self->_setValue($key, $value);
    }
    return 1;
}

sub isKeyValid{
    my ($self, $key, $optionTimeout) = @_;

    for (@{$self->{config}->getTimeoutValues()}) {
        return 1 if ($key eq $_);
    }
    return 0;
}

sub isValueValid {
    my ($self, $value) = @_;
    return 1 if ($value eq '');
    return 0 if ($value !~ /^\d+$/ || $value !~ /^[1-9][0-9]*$/);
    return 1;
}

sub _resetValue {
    my ($self, $key) = @_;
    $self->_setValue($key, "");
}

sub _setValue {
    my ($self, $key, $value) = @_;

    $self->{config}->{params}->{Timeouts}->{value}->{$key} = $value;
    $self->{_args}->{$key} = $value;
}

sub getValueByKey {
    my ($self, $key, $isBatchValue) = @_;
    my $config = $self->{config};
    return $config->{params}->{Timeouts}->{batchValue}->{$key} if $isBatchValue;

    my $value = $config->{params}->{Timeouts}->{value}->{$key};
    return $value if (defined $value);
    my $optionTimeout = $config->getOptionTimeout();
    return $optionTimeout->getArg($key);
}

1;
