package LCM::Task::ComponentList::PrintComponentBaseTask;
use strict;
use warnings;

use parent 'LCM::Task';
use SDB::Install::Tools qw(printTableToArrayOfLines);
use LCM::Utils::ComponentActionStringGenerator;

sub getComponentTable {
    my ($self) = @_;
    my $table = printTableToArrayOfLines($self->getComponentRows(), ' | ', 1);
    return '  ' . join ("\n  ", @$table) . "\n\n";
}

sub getSortedComponents {
    my ($self, $componentManager) = @_;

    my $keynamePriorityMap = $LCM::Utils::ComponentActionStringGenerator::keynameToSortKey;
    my @sortedComponents = sort {
        my $prio1 = $keynamePriorityMap->{$a->getComponentKeyName()} // $keynamePriorityMap->{_UNKNOWN};
        my $prio2 = $keynamePriorityMap->{$b->getComponentKeyName()} // $keynamePriorityMap->{_UNKNOWN};
        $prio1 <=> $prio2
    } @{$componentManager->getAllComponents()};

    return \@sortedComponents;
}

sub getComponentRows {
    ...
}

1;