package LCM::Task::ComponentList::PrintComponentListTask;
use parent 'LCM::Task::ComponentList::PrintComponentBaseTask';
use strict;
use warnings;

sub getId {
    return "print_component_list_task";
}

sub getName {
    return "Print component list";
}

sub getExecutionName {
    return "Print component list";
}

sub _executeInternal {
    my ($self) = @_;
    my $config = $self->_getConfiguration();
    my $ownSapSystem = $config->getSAPSystem(1);

    if(!defined($ownSapSystem)){
        my $sid = $config->getSID();
        $self->getErrMsgLst()->addError("No SAP system '$sid' found");
        $self->getStatus()->_setErrorState();
        return 0;
    }
    my $outputFormat = $config->getValue('Format');
    if ($outputFormat eq 'xml') {
        my $landscapeDescriptionXml = new LCM::Landscape::DescriptionXML($self->getMsgLstContext(), $ownSapSystem, 1);
        print($landscapeDescriptionXml->toString(1));
    } else {
        print $self->getComponentTable();
    }
    $self->getStatus()->_setFinishedState();
    return 1;
}

sub getComponentRows {
    my ($self) = @_;
    my $config = $self->_getConfiguration();
    my $scm = $config->getSystemComponentManager();
    my @sortedComponents = @ {$self->getSortedComponents($scm)};

    my $i = 1;
    my @rows = map {[$i++, $_->getComponentName(), $_->getVersion(), $_->getComponentKeyName(), $_->getComponentBatchKey()]} @sortedComponents;
    unshift(@rows, ['Index', 'Name', 'Version', 'Technical Name', 'Batch Key']);

    return \@rows;
}

1;