package LCM::Task::ComponentList::PrintDetectedComponentsTask;

use strict;
use warnings;
use parent 'LCM::Task::ComponentList::PrintComponentBaseTask';

my $EMPTY_PARAMETERS_VALUE_ERROR_MESSAGE = "At least one of the parameters: %s, %s or %s has to be set.";

sub getId {
    return "print_detected_components_task";
}

sub getName {
    return "Print detected components";
}

sub getExecutionName {
    return "Print detected components";
}

sub _executeInternal {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();
    my $componentsPath = $configuration->getValueOrBatchValue('ComponentFsRoot')
                        || $configuration->getValueOrBatchValue('ComponentDirs')
                        || $configuration->getValueOrBatchValue('DvdPath');

    if(!$componentsPath) {
        my $msg = sprintf (
            $EMPTY_PARAMETERS_VALUE_ERROR_MESSAGE,
            $configuration->getOpt('ComponentFsRoot', 0),
            $configuration->getOpt('ComponentDirs', 0),
            $configuration->getOpt('DvdPath', 0)
        );
        $self->setErrorMessage($msg, $self->getErrMsgLst());
        $self->getStatus()->_setErrorState();
    } else {
        $self->getStatus()->_setFinishedState();
        print $self->getComponentTable();
    }
}

sub getComponentRows {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();
    my $componentManager = $configuration->getComponentManager();
    my @sortedComponents = @{$self->getSortedComponents($componentManager)};

    my $i = 1;
    my @rows = map {[
        $i++,
        $_->getComponentName(),
        $_->getVersion(),
        $_->getComponentBatchKey(),
        $_->getPath()
    ]} @sortedComponents;

    unshift(@rows,[
        'Index',
        'Name',
        'Version',
        'Batch Key',
        'Location'
    ]);

    return \@rows;
}

1;