package LCM::Task::ConvertToMultiDBTask::ForceSystemDBUserPasswordChangeTask;

use strict;
use warnings;
use parent 'LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask';
use SDB::Install::SAPInstance;
use LCM::Component::Installed::HDBServer;

my $SQL_STATEMENT_TEMPLATE = 'ALTER USER %s FORCE PASSWORD CHANGE';

our $PROGRESS_MESSAGE = "Forcing password change for system database user...";
my $SUCCESS_END_MESSAGE = "Forced password change for system database user";
my $FAIL_END_MESSAGE = "Forcing password change for system database user failed";

our @EXPORT = qw($PROGRESS_MESSAGE $ID);

sub getId {
    return 'force_password_change_system_db';
}

sub getName {
    return 'Forcing password change for system database user';
}

sub getExecutionName {
    return 'Forcing password change for system database user';
}

sub getSuccessMessage{
    return $SUCCESS_END_MESSAGE;
}
sub getFailedMessage{
    return $FAIL_END_MESSAGE;
}
sub getProgressMessage{
    return $PROGRESS_MESSAGE;
}
sub getServerCurrentConversionState{
    return LCM::Component::Installed::HDBServer::CONVERT_MDC_FINISHED;
}
sub _executeConvertStep{
    my($self,$configuration) = @_;
    my $sapSystem = $configuration->getSAPSystem (1);
    my $trexInstance = $configuration->getOwnInstance();
    $trexInstance->setMsgLstContext ([$self->getMsgLst()]);
    return $self->_forcePasswordChange( $configuration,$trexInstance);
}

sub _forcePasswordChange {
    my ($self, $configuration, $trexInstance) = @_;
    my $instanceNumber = $trexInstance->get_nr();
    my $dbUser =  LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask::SYSTEM_USER;
    my $sqlQuery = sprintf($SQL_STATEMENT_TEMPLATE, $dbUser);
    my $password = $configuration->getValue ('SystemDBSQLPassword');
    my $host = $trexInstance->getSqlHost();
    my $connection=$self->_createConnection($host, $instanceNumber, $dbUser, $password, $trexInstance);
    if(defined $connection){
       my $msglst = $self->getMsgLst ();
       my $msg = $msglst->addMessage ("Performing SQL statement '$sqlQuery'");
       $connection->setMsgLstContext ([$msg->getSubMsgLst ()]);
       if (!defined $connection->execute ($sqlQuery)){
           $self->setErrorMessage("Sql execute failed", $connection->getErrMsgLst());
           $msglst->addWarning('Forcing password change for system database user failed');
           return undef;
       }
       return 1;
    }
    return 0;
}

sub _getNumberOfExpectedOutputLines {
    return 2;
}

sub initProgressHandler{
    my ($self) = @_;
    $self->getMsgLst()->setProgressHandler(new LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler($self));
}

1;
