package LCM::Task::ConvertToMultiDBTask::InitializeSystemUserInMultiDbTask;

use strict;
use File::Spec;
use File::Basename;
use SDB::Install::Configuration qw($bool_false_pattern);
use LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler;
use parent 'LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask';
use LCM::Component::Installed::HDBServer;

my $CONFIGURATION_NAME = 'multitenant database containers';
my $PROGRESS_MESSAGE = "Initializing database user (SYSTEM) for the system database...";
my $SUCCESS_END_MESSAGE = "Finished initialization of database user (SYSTEM) for the system database";
my $FAIL_END_MESSAGE = "Initialization of database user (SYSTEM) for the system database failed";

our @EXPORT = qw($PROGRESS_MESSAGE);

sub getId {
    return 'init_system_user_mutlidb';
}

sub getName {
    return 'Initializing database user (SYSTEM) for the system database';
}

sub getExecutionName {
    return 'Initializing database user (SYSTEM) for the system database';
}

sub getSuccessMessage{
    return $SUCCESS_END_MESSAGE; 
}
sub getFailedMessage{
    return $FAIL_END_MESSAGE;
}
sub getProgressMessage{
    return $PROGRESS_MESSAGE;
}
sub getServerCurrentConversionState{
    my $self = shift;
    my $configuration = $self->_getConfiguration();
    my $isFinished = $configuration->isServerNoStart() && !$configuration->hasStreaming() ;
    return $isFinished ? LCM::Component::Installed::HDBServer::CONVERT_MDC_FINISHED : LCM::Component::Installed::HDBServer::CONVERT_MDC_STARTED;
}

sub _executeConvertStep{
    my($self,$configuration) = @_;
    my $sapSystem = $configuration->getSAPSystem (1);
    my $trexInstance = $configuration->getOwnInstance();
    my $progressHandler = $self->getMsgLst()->getProgressHandler();
    if(defined $progressHandler){
       $sapSystem->SetProgressHandler   ($progressHandler);
       $trexInstance->SetProgressHandler($progressHandler);
    }
    return $self->_resetUserSystem($trexInstance, $configuration);
}

sub _resetUserSystem {
    my ($self, $trexInstance, $configuration) = @_;
    my $systemUserPwd = $configuration->getValue('SystemDBSQLPassword');
# The hdbnameserver expects confirmation for the password of the
# newly created SYSTEMDB. For more info see Bug 200876.
    my $stdinPasswords = [ $systemUserPwd, $systemUserPwd ];
    my $command = File::Spec->catfile($trexInstance->get_instanceExeDir(), 'hdbnameserver');
    return $self->_runWrappedCommand($command, ['-resetUserSystem'], $stdinPasswords);
}

sub _getNumberOfExpectedOutputLines {
    return 50;
}

sub initProgressHandler {
    my ($self) = @_;
    $self->getMsgLst()->setProgressHandler(new LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler($self));
}

1;